/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.CreationInfo;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.util.Map;

@Description(value="Testing results declared in component configurations.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class)})
public class ComponentResultTestAgent
extends MicroAgent {
    public void executeBody() {
        final TestReport tr1 = new TestReport("#1", "Default configuration.");
        this.testComponentResult(null, "initial1").addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                tr1.setSucceeded(true);
                this.next();
            }

            public void exceptionOccurred(Exception exception) {
                tr1.setFailed(exception.getMessage());
                this.next();
            }

            protected void next() {
                final TestReport tr2 = new TestReport("#2", "Custom configuration");
                ComponentResultTestAgent.this.testComponentResult("config2", "initial2").addResultListener(ComponentResultTestAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        tr2.setSucceeded(true);
                        this.next();
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr2.setFailed(exception.getMessage());
                        this.next();
                    }

                    protected void next() {
                        ComponentResultTestAgent.this.setResultValue("testresults", new Testcase(2, new TestReport[]{tr1, tr2}));
                        ComponentResultTestAgent.this.killAgent();
                    }
                }));
            }
        }));
    }

    protected IFuture testComponentResult(final String config, final String expected) {
        final Future fut = new Future();
        this.getRequiredService("cms").addResultListener((IResultListener)new DelegationResultListener(fut){

            public void customResultAvailable(Object result) {
                final IComponentManagementService cms = (IComponentManagementService)result;
                cms.createComponent(null, "jadex/micro/testcases/Result.component.xml", new CreationInfo(config, null, ComponentResultTestAgent.this.getComponentIdentifier()), null).addResultListener(ComponentResultTestAgent.this.createResultListener((IResultListener)new DelegationResultListener(fut){

                    public void customResultAvailable(Object result) {
                        cms.destroyComponent((IComponentIdentifier)result).addResultListener((IResultListener)new DelegationResultListener(fut){

                            public void customResultAvailable(Object result) {
                                Map results = (Map)result;
                                if (results == null || !SUtil.equals(results.get("res"), (Object)expected)) {
                                    throw new RuntimeException("Results do not match, expected res=" + expected + " but got: " + results);
                                }
                                super.customResultAvailable(null);
                            }
                        });
                    }
                }));
            }
        });
        return fut;
    }
}

