/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.fipa.IDF;
import jadex.base.fipa.IDFComponentDescription;
import jadex.base.fipa.IDFServiceDescription;
import jadex.base.fipa.SFipa;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ISearchConstraints;
import jadex.bridge.MessageType;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.IArgument;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DFTestAgent
extends MicroAgent {
    protected List reports;

    public void executeBody() {
        this.reports = new ArrayList();
        this.registerDF();
    }

    public IFuture agentKilled() {
        this.setResultValue("testresults", new Testcase(this.reports.size(), this.reports.toArray(new TestReport[this.reports.size()])));
        this.getServiceContainer().searchService(IDF.class).addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IDF df = (IDF)result;
                IDFComponentDescription ad = df.createDFComponentDescription(DFTestAgent.this.getComponentIdentifier(), null);
                df.deregister(ad);
            }
        });
        return IFuture.DONE;
    }

    protected void registerDF() {
        final TestReport tr = new TestReport("#1", "Test DF registration.");
        this.reports.add(tr);
        this.getServiceContainer().searchService(IDF.class).addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IDF df = (IDF)result;
                IDFServiceDescription sd = df.createDFServiceDescription(null, "testType", null);
                IDFComponentDescription ad = df.createDFComponentDescription(DFTestAgent.this.getComponentIdentifier(), sd);
                IFuture ret = df.register(ad);
                ret.addResultListener(DFTestAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        tr.setSucceeded(true);
                        DFTestAgent.this.searchDF();
                    }

                    public void exceptionOccurred(Exception e) {
                        tr.setFailed(e.toString());
                        DFTestAgent.this.killAgent();
                    }
                }));
            }
        });
    }

    protected void searchDF() {
        final TestReport tr = new TestReport("#2", "Test DF search.");
        this.reports.add(tr);
        this.getServiceContainer().searchService(IDF.class).addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IDF df = (IDF)result;
                IDFServiceDescription sd = df.createDFServiceDescription(null, "testType", null);
                IDFComponentDescription ad = df.createDFComponentDescription(null, sd);
                ISearchConstraints cons = df.createSearchConstraints(-1, 0);
                IFuture ret = df.search(ad, cons);
                ret.addResultListener(DFTestAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        IDFComponentDescription[] agentDesc = (IDFComponentDescription[])result;
                        if (agentDesc.length != 0) {
                            tr.setSucceeded(true);
                            IComponentIdentifier receiver = agentDesc[0].getName();
                            DFTestAgent.this.sendMessageToReceiver(receiver);
                        } else {
                            tr.setFailed("No suitable service found.");
                            DFTestAgent.this.killAgent();
                        }
                    }

                    public void exceptionOccurred(Exception e) {
                        tr.setFailed(e.toString());
                        DFTestAgent.this.killAgent();
                    }
                }));
            }
        });
    }

    private void sendMessageToReceiver(IComponentIdentifier cid) {
        final TestReport tr = new TestReport("#3", "Test sending message to service (i.e. myself).");
        this.reports.add(tr);
        HashMap<String, String> hlefMessage = new HashMap<String, String>();
        hlefMessage.put("performative", "inform");
        hlefMessage.put("sender", (String)this.getComponentIdentifier());
        hlefMessage.put("receivers", (String)cid);
        hlefMessage.put("content", "testMessage");
        this.sendMessage(hlefMessage, SFipa.FIPA_MESSAGE_TYPE);
        this.waitFor(1000L, new IComponentStep(){

            public Object execute(IInternalAccess ia) {
                tr.setFailed("No message received.");
                DFTestAgent.this.killAgent();
                return null;
            }
        });
    }

    public void messageArrived(Map msg, MessageType mt) {
        TestReport tr = (TestReport)this.reports.get(this.reports.size() - 1);
        if ("testMessage".equals(msg.get("content"))) {
            tr.setSucceeded(true);
        } else {
            tr.setFailed("Wrong message received: " + msg);
        }
        this.killAgent();
    }

    public static Object getMetaInfo() {
        return new MicroAgentMetaInfo("Test DF usage from micro agent.", null, null, new IArgument[]{new Argument("testresults", null, "Testcase")});
    }
}

