/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.annotation.Value;
import jadex.micro.testcases.IAService;
import jadex.micro.testcases.SimpleInterceptor;
import java.util.ArrayList;
import java.util.List;

@Description(value="Testing if required services can be equipped with interceptors.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@ProvidedServices(value={@ProvidedService(name="aservice", type=IAService.class, implementation=@Implementation(expression="$component", interceptors={@Value(value="$component.provinter")}))})
@RequiredServices(value={@RequiredService(name="aservice", type=IAService.class, binding=@Binding(scope="local", interceptors={@Value(value="$component.reqinter")}))})
public class InterceptorAgent
extends MicroAgent
implements IAService {
    public SimpleInterceptor provinter = new SimpleInterceptor();
    public SimpleInterceptor reqinter = new SimpleInterceptor();

    public void executeBody() {
        final ArrayList testresults = new ArrayList();
        this.performProvidedServiceTest(testresults).addResultListener(this.createResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                InterceptorAgent.this.performRequiredServiceTest(testresults).addResultListener(InterceptorAgent.this.createResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object result) {
                        TestReport[] tr = testresults.toArray(new TestReport[testresults.size()]);
                        InterceptorAgent.this.setResultValue("testresults", new Testcase(tr.length, tr));
                        InterceptorAgent.this.killAgent();
                    }
                }));
            }
        }));
    }

    public IFuture performProvidedServiceTest(final List testresults) {
        final Future ret = new Future();
        IAService ser = (IAService)this.getServiceContainer().getProvidedService("aservice");
        ser.test().addResultListener((IResultListener)new DelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                TestReport tr = new TestReport("#1", "Provided service test.");
                if (InterceptorAgent.this.provinter.getCnt() == 1) {
                    tr.setSucceeded(true);
                } else {
                    tr.setReason("Wrong interceptor count: " + InterceptorAgent.this.provinter.getCnt());
                }
                testresults.add(tr);
                ret.setResult(null);
            }
        });
        return ret;
    }

    public IFuture performRequiredServiceTest(final List testresults) {
        final Future ret = new Future();
        this.getRequiredService("aservice").addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IAService ser = (IAService)result;
                ser.test().addResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object result) {
                        TestReport tr = new TestReport("#2", "Required service test.");
                        if (InterceptorAgent.this.reqinter.getCnt() == 1) {
                            tr.setSucceeded(true);
                        } else {
                            tr.setReason("Wrong interceptor count: " + InterceptorAgent.this.reqinter.getCnt());
                        }
                        testresults.add(tr);
                        ret.setResult(null);
                    }
                });
            }
        });
        return ret;
    }

    @Override
    public IFuture test() {
        return IFuture.DONE;
    }
}

