/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.service.clock.IClockService;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@Description(value="Tests the logger.")
@Results(value={@Result(name="testresults", description="The test results.", clazz=Testcase.class)})
@RequiredServices(value={@RequiredService(name="clockservice", type=IClockService.class, binding=@Binding(scope="global"))})
public class LoggerAgent
extends MicroAgent {
    public void executeBody() {
        this.getRequiredService("clockservice").addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                final IClockService clock = (IClockService)result;
                final long start = clock.getTime();
                String ct = clock.getClockType();
                final boolean simclock = "event_driven".equals(ct) || "time_driven".equals(ct);
                final TestReport tr = new TestReport("#1", "Test logging.");
                LoggerAgent.this.getLogger().setLevel(Level.FINEST);
                LoggerAgent.this.getLogger().addHandler(new Handler(){

                    @Override
                    public void publish(LogRecord record) {
                        long end = clock.getTime();
                        long diff = end - start;
                        if (simclock && diff == 0L || !simclock && diff < 1000L) {
                            tr.setSucceeded(true);
                        } else {
                            tr.setReason("Time in log record differs substantially: " + end + " " + start + " " + diff);
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() throws SecurityException {
                    }
                });
                LoggerAgent.this.getLogger().info("test log message");
                LoggerAgent.this.setResultValue("testresults", new Testcase(1, new TestReport[]{tr}));
                LoggerAgent.this.killAgent();
            }
        });
    }
}

