/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.semiautomatic.compositeservice.IAddService;
import jadex.micro.testcases.semiautomatic.compositeservice.ISubService;

@ProvidedServices(value={@ProvidedService(type=IAddService.class, implementation=@Implementation(expression="$component")), @ProvidedService(type=ISubService.class, implementation=@Implementation(expression="$component"))})
@RequiredServices(value={@RequiredService(name="add", type=IAddService.class), @RequiredService(name="sub", type=ISubService.class)})
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
public class MultiServiceAgent
extends MicroAgent
implements IAddService,
ISubService {
    public void executeBody() {
        final Future fut = new Future();
        this.getRequiredService("add").addResultListener((IResultListener)new DelegationResultListener(fut){

            public void customResultAvailable(Object result) {
                final IAddService add = (IAddService)result;
                MultiServiceAgent.this.getRequiredService("sub").addResultListener((IResultListener)new DelegationResultListener(fut){

                    public void customResultAvailable(Object result) {
                        final ISubService sub = (ISubService)result;
                        add.add(17.0, 4.0).addResultListener((IResultListener)new DelegationResultListener(fut){

                            public void customResultAvailable(Object result) {
                                Double val = (Double)result;
                                sub.sub(val, 12.0).addResultListener((IResultListener)new DelegationResultListener(fut));
                            }
                        });
                    }
                });
            }
        });
        final TestReport tr = new TestReport("#1", "Test if multiple services can be used.");
        fut.addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                tr.setSucceeded(true);
                MultiServiceAgent.this.setResultValue("testresults", new Testcase(1, new TestReport[]{tr}));
                MultiServiceAgent.this.killAgent();
            }

            public void exceptionOccurred(Exception exception) {
                tr.setFailed(exception.toString());
                MultiServiceAgent.this.setResultValue("testresults", new Testcase(1, new TestReport[]{tr}));
                MultiServiceAgent.this.killAgent();
            }
        }));
    }

    @Override
    public IFuture add(double a, double b) {
        return new Future((Object)new Double(a + b));
    }

    @Override
    public IFuture sub(double a, double b) {
        return new Future((Object)new Double(a - b));
    }
}

