/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.semiautomatic;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import java.util.Arrays;
import java.util.HashSet;

public class CountingAgent
extends MicroAgent {
    protected int cnt;

    public void executeBody() {
        this.cnt = 1;
        IComponentStep step = new IComponentStep(){

            public Object execute(IInternalAccess ia) {
                final 1 step = this;
                System.out.println("Step: " + CountingAgent.this.cnt);
                ++CountingAgent.this.cnt;
                CountingAgent.this.waitFor(10L, new IComponentStep(){

                    public Object execute(IInternalAccess ia) {
                        CountingAgent.this.scheduleStep(step);
                        return null;
                    }
                });
                return null;
            }

            public String toString() {
                return "counter.inc(" + CountingAgent.this.cnt + ")";
            }
        };
        this.scheduleStep(step);
    }

    public boolean isAtBreakpoint(String[] breakpoints) {
        boolean isatbreakpoint = false;
        HashSet<String> bps = new HashSet<String>(Arrays.asList(breakpoints));
        isatbreakpoint = isatbreakpoint || bps.contains(Integer.toString(this.cnt));
        isatbreakpoint = isatbreakpoint || this.cnt % 2 != 0 && bps.contains("odd");
        isatbreakpoint = isatbreakpoint || this.cnt % 2 == 0 && bps.contains("even");
        isatbreakpoint = isatbreakpoint || this.cnt % 10 == 0 && bps.contains("every tenth");
        return isatbreakpoint;
    }

    public static Object getMetaInfo() {
        return new MicroAgentMetaInfo("A simple agent showing how to use breakpoints in the micro kernel.", null, null, null, new String[]{"2", "5", "odd", "even", "every tenth"}, null);
    }
}

