/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.semiautomatic.remoteservice;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IRemoteServiceManagementService;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.testcases.semiautomatic.remoteservice.IMathService;

public class UserAgent
extends MicroAgent {
    public void executeBody() {
        final CounterResultListener lis = new CounterResultListener(2, new IResultListener(){

            public void resultAvailable(Object result) {
                UserAgent.this.killAgent();
            }

            public void exceptionOccurred(Exception exception) {
                UserAgent.this.killAgent();
            }
        });
        this.getServiceContainer().searchServiceUpwards(IComponentManagementService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                final IComponentManagementService cms = (IComponentManagementService)result;
                UserAgent.this.getServiceContainer().searchService(IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                        IComponentIdentifier platid = cms.createComponentIdentifier("remote", false, new String[]{"tcp-mtp://127.0.0.1:11000", "nio-mtp://127.0.0.1:11001"});
                        rms.getServiceProxy(platid, IMathService.class, "platform").addResultListener(UserAgent.this.createResultListener(new IResultListener(){

                            public void resultAvailable(Object result) {
                                IMathService service = (IMathService)result;
                                UserAgent.this.invokeAddService("IMathService searched via rms.", service).addResultListener((IResultListener)lis);
                            }

                            public void exceptionOccurred(Exception exception) {
                                lis.resultAvailable(null);
                            }
                        }));
                    }

                    public void exceptionOccurred(Exception exception) {
                        lis.resultAvailable(null);
                    }
                });
            }

            public void exceptionOccurred(Exception exception) {
                lis.resultAvailable(null);
            }
        });
        this.getServiceContainer().searchService(IMathService.class, "global").addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                IMathService service = (IMathService)result;
                UserAgent.this.invokeAddService("IMathService searched via platform proxy.", service).addResultListener((IResultListener)lis);
            }

            public void exceptionOccurred(Exception exception) {
                lis.resultAvailable(null);
            }
        });
    }

    protected IFuture invokeAddService(String info, IMathService service) {
        Future ret = new Future();
        if (service == null) {
            System.out.println("No remote add service found: " + info);
            ret.setResult(null);
        } else {
            final CounterResultListener lis = new CounterResultListener(2, (IResultListener)new DelegationResultListener(ret));
            System.out.println("Found service: " + info);
            service.addNB(1, 2).addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    System.out.println("Invoked addNB: " + result);
                    lis.resultAvailable(null);
                }

                public void exceptionOccurred(Exception exception) {
                    lis.resultAvailable(null);
                }
            });
            int res = service.addB(1, 2);
            System.out.println("Invoked addB: " + res);
            System.out.println("Calling constant (non-blocking) getPi method.");
            double pi = service.getPi();
            System.out.println("Invoked getPi: " + pi);
            System.out.println("Calling void (non-blocking) printMessage method.");
            service.printMessage("math service");
            System.out.println("Invoked printMessage");
            System.out.println("Calling (non-blocking) exception throwing divZero method.");
            service.divZero().addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    System.out.println("Invoked divZero without exception");
                    lis.resultAvailable(null);
                }

                public void exceptionOccurred(Exception exception) {
                    System.out.println("Invoked divZero, expected exception occurred: " + exception);
                    lis.resultAvailable(null);
                }
            });
        }
        return ret;
    }
}

