/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.ParseException;
import jadex.javaparser.javaccimpl.ParserImpl;

public class BooleanNode
extends ExpressionNode {
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    protected int op;

    public BooleanNode(ParserImpl p, int id) {
        super(p, id);
        this.setStaticType(Boolean.class);
    }

    public void setText(String text) {
        super.setText(text);
        this.op = BooleanNode.fromString(text);
    }

    public void precompile() {
        if ((this.op == 1 || this.op == 2) && this.jjtGetNumChildren() < 2 || this.op == 3 && this.jjtGetNumChildren() != 1) {
            throw new ParseException("Wrong number of subterms for expression: " + this);
        }
        if (this.op != 1 && this.op != 2 && this.op != 3) {
            throw new ParseException("Unknown operator type " + this.op + ": " + this);
        }
        boolean allfalse = true;
        boolean alltrue = true;
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ExpressionNode node = (ExpressionNode)this.jjtGetChild(i);
            Class type = node.getStaticType();
            if (type != null && !type.equals(class$java$lang$Boolean == null ? BooleanNode.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                throw new ParseException("Term of expression not boolean: " + this);
            }
            if (node.isConstant()) {
                try {
                    boolean val = (Boolean)node.getValue(null);
                    allfalse = allfalse && !val;
                    boolean bl = alltrue = alltrue && val;
                    if (this.op == 3) {
                        this.setConstant(true);
                        this.setConstantValue(new Boolean(!val));
                        continue;
                    }
                    if (this.op == 1 && !val) {
                        this.setConstant(true);
                        this.setConstantValue(new Boolean(false));
                        continue;
                    }
                    if (this.op != 2 || !val) continue;
                    this.setConstant(true);
                    this.setConstantValue(new Boolean(true));
                }
                catch (Exception e) {}
                continue;
            }
            allfalse = false;
            alltrue = false;
        }
        if (this.op == 1 && alltrue) {
            this.setConstant(true);
            this.setConstantValue(new Boolean(true));
        } else if (this.op == 2 && allfalse) {
            this.setConstant(true);
            this.setConstantValue(new Boolean(false));
        }
    }

    public Object getValue(IValueFetcher fetcher) {
        boolean ret;
        if (this.isConstant()) {
            return this.getConstantValue();
        }
        switch (this.op) {
            case 1: {
                ret = true;
                for (int i = 0; i < this.jjtGetNumChildren() && ret; ++i) {
                    Object val = ((ExpressionNode)this.jjtGetChild(i)).getValue(fetcher);
                    if (!(val instanceof Boolean)) {
                        throw new RuntimeException("Term of expression not boolean: " + this + ", " + val);
                    }
                    ret = (Boolean)val;
                }
                break;
            }
            case 2: {
                ret = false;
                for (int i = 0; i < this.jjtGetNumChildren() && !ret; ++i) {
                    Object val = ((ExpressionNode)this.jjtGetChild(i)).getValue(fetcher);
                    if (!(val instanceof Boolean)) {
                        throw new RuntimeException("Term of expression not boolean: " + this);
                    }
                    ret = (Boolean)val;
                }
                break;
            }
            case 3: {
                Object val = ((ExpressionNode)this.jjtGetChild(0)).getValue(fetcher);
                if (!(val instanceof Boolean)) {
                    throw new RuntimeException("Term of expression not boolean: " + this);
                }
                ret = (Boolean)val == false;
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator type " + this.op + ": " + this);
            }
        }
        return new Boolean(ret);
    }

    public String toPlainString() {
        String ret;
        if (this.jjtGetNumChildren() > 1) {
            ret = this.subnodeToString(0);
            for (int i = 1; i < this.jjtGetNumChildren(); ++i) {
                ret = ret + BooleanNode.toString(this.op) + this.subnodeToString(i);
            }
        } else {
            ret = BooleanNode.toString(this.op) + this.subnodeToString(0);
        }
        return ret;
    }

    public static String toString(int operator) {
        switch (operator) {
            case 1: {
                return "&&";
            }
            case 2: {
                return "||";
            }
            case 3: {
                return "!";
            }
        }
        return "" + operator;
    }

    public static int fromString(String operator) {
        if ("&&".equals(operator)) {
            return 1;
        }
        if ("||".equals(operator)) {
            return 2;
        }
        if ("!".equals(operator)) {
            return 3;
        }
        throw new ParseException("Unknown operator: " + operator);
    }
}

