/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ServiceCall;
import jadex.bridge.modelinfo.IExtensionInstance;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractEnvironmentService {
    @ServiceComponent
    protected IInternalAccess component;
    protected String spacename;
    protected IEnvironmentSpace space;

    public AbstractEnvironmentService(String spacename) {
        this.spacename = spacename;
    }

    public ISubscriptionIntermediateFuture<Object> register(final String objecttype) {
        SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture(new ITerminationCommand(){

            public void terminated(Exception reason) {
                System.out.println("Terminated...");
            }

            public boolean checkTermination(Exception reason) {
                return true;
            }
        });
        this.getCallingComponent().addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentDescription, Collection<Object>>((Future)ret){

            public void customResultAvailable(IComponentDescription desc) {
                HashMap<String, IComponentDescription> props = new HashMap<String, IComponentDescription>();
                props.put("owner", desc);
                AbstractEnvironmentService.this.space.createSpaceObject(objecttype, props, null);
            }
        });
        return ret;
    }

    public IFuture<Void> performAction(final String actiontype, final Map<String, Object> parameters) {
        final Future ret = new Future();
        this.getCallingComponent().addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentDescription, Void>(ret){

            public void customResultAvailable(IComponentDescription desc) {
                parameters.put("actor_id", desc);
                AbstractEnvironmentService.this.space.performSpaceAction(actiontype, parameters, (IResultListener)new ExceptionDelegationResultListener<Object, Void>(ret){

                    public void customResultAvailable(Object result) {
                        ret.setResult(null);
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<IComponentDescription> getCallingComponent() {
        final Future ret = new Future();
        final IComponentIdentifier caller = ServiceCall.getCurrentInvocation().getCaller();
        final Future spacedone = new Future();
        if (this.space == null) {
            this.component.getExternalAccess().getExtension(this.spacename).addResultListener((IResultListener)new ExceptionDelegationResultListener<IExtensionInstance, IComponentDescription>(ret){

                public void customResultAvailable(IExtensionInstance result) {
                    AbstractEnvironmentService.this.space = (IEnvironmentSpace)result;
                    spacedone.setResult(null);
                }
            });
        } else {
            spacedone.setResult(null);
        }
        spacedone.addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, IComponentDescription>(ret){

            public void customResultAvailable(Void result) {
                AbstractEnvironmentService.this.component.getServiceContainer().searchService(IComponentManagementService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, IComponentDescription>(ret){

                    public void customResultAvailable(IComponentManagementService cms) {
                        cms.getComponentDescription(caller).addResultListener((IResultListener)new DelegationResultListener(ret));
                    }
                });
            }
        });
        return ret;
    }
}

