/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport;

import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.modelinfo.IExtensionInfo;
import jadex.bridge.modelinfo.IExtensionInstance;
import jadex.commons.IValueFetcher;
import jadex.commons.SReflect;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.extension.envsupport.MEnvSpaceType;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import java.util.List;
import java.util.Map;

public class MEnvSpaceInstance
implements IExtensionInfo {
    protected String name;
    protected String type;
    protected MEnvSpaceType spacetype;
    protected Map properties;

    public IFuture<IExtensionInstance> createInstance(final IExternalAccess access, final IValueFetcher fetcher) {
        return access.scheduleStep((IComponentStep)new IComponentStep<IExtensionInstance>(){

            public IFuture<IExtensionInstance> execute(IInternalAccess ia) {
                Future ret;
                try {
                    Class clazz = SReflect.findClass((String)MEnvSpaceInstance.this.spacetype.getClassName(), (String[])access.getModel().getAllImports(), (ClassLoader)ia.getClassLoader());
                    AbstractEnvironmentSpace space = (AbstractEnvironmentSpace)clazz.newInstance();
                    space.setInitData(ia, MEnvSpaceInstance.this, fetcher);
                    ret = new Future((Object)space);
                }
                catch (Exception e) {
                    ret = new Future(e);
                }
                return ret;
            }
        });
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new MultiCollection();
        }
        this.properties.put(key, value);
    }

    public List getPropertyList(String key) {
        return this.properties != null ? (List)this.properties.get(key) : null;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.properties != null ? MEnvSpaceType.getProperty(this.properties, name) : null;
    }

    public String getTypeName() {
        return this.type;
    }

    public void setTypeName(String type) {
        this.type = type;
    }

    public MEnvSpaceType getType() {
        return this.spacetype;
    }

    public void setType(MEnvSpaceType spacetype) {
        this.spacetype = spacetype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

