/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.dataview;

import jadex.extension.envsupport.dataview.IDataView;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Double;
import java.util.Map;

public class LocalDataView2D
implements IDataView {
    protected Space2D space;
    protected ISpaceObject object;
    protected Object range;

    @Override
    public String getType() {
        return "Simple 2D View";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getObjects() {
        Object object = this.space.getMonitor();
        synchronized (object) {
            IVector2 pos = (IVector2)this.object.getProperty("position");
            if (!(this.range instanceof IVector1)) {
                throw new RuntimeException("Range must be vector1: " + this.range);
            }
            Object[] ret = this.space.getNearObjects(pos, (IVector1)this.range).toArray(new ISpaceObject[0]);
            return ret;
        }
    }

    @Override
    public void update(IEnvironmentSpace space) {
        this.space = (Space2D)space;
    }

    @Override
    public void init(IEnvironmentSpace space, Map props) {
        this.space = (Space2D)space;
        this.object = (ISpaceObject)props.get("object");
        this.range = props.get("range");
        if (this.range instanceof Number) {
            this.range = new Vector1Double(((Number)props.get("range")).doubleValue());
        }
    }
}

