/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment;

import jadex.commons.ICommand;
import jadex.commons.IFilter;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ComponentActionList {
    protected IEnvironmentSpace space;
    protected Set actions;
    protected Collection executed;
    protected ICommand cmd;

    public ComponentActionList(IEnvironmentSpace space) {
        this.space = space;
    }

    public void scheduleComponentAction(ISpaceAction action, Map parameters, IResultListener listener) {
        ActionEntry entry = new ActionEntry(action, parameters, listener);
        if (this.cmd != null) {
            this.cmd.execute((Object)entry);
        } else {
            this.addComponentAction(entry);
        }
    }

    public void addComponentAction(ActionEntry entry) {
        if (this.actions == null) {
            this.actions = new LinkedHashSet();
        }
        this.actions.add(entry);
    }

    public void removeComponentAction(ActionEntry entry) {
        if (this.actions != null) {
            this.actions.remove(entry);
        }
    }

    public ActionEntry[] getActionEntries() {
        ActionEntry[] ret = this.actions != null ? this.actions.toArray(new ActionEntry[this.actions.size()]) : new ActionEntry[]{};
        return ret;
    }

    public void setOrdering(Comparator comp) {
        if (this.actions != null) {
            TreeSet tmp = new TreeSet(comp);
            tmp.addAll(this.actions);
            this.actions = tmp;
        } else {
            this.actions = new TreeSet(comp);
        }
    }

    public void executeActions(IFilter filter, boolean wakeup) {
        if (this.actions != null && !this.actions.isEmpty()) {
            Iterator it = this.actions.iterator();
            while (it.hasNext()) {
                ActionEntry entry = (ActionEntry)it.next();
                try {
                    if (filter != null && !filter.filter((Object)entry)) continue;
                    it.remove();
                    try {
                        if (!entry.invalid) {
                            Object ret = entry.action.perform(entry.parameters, this.space);
                            if (entry.listener == null) continue;
                            if (wakeup) {
                                entry.listener.resultAvailable(ret);
                                continue;
                            }
                            entry.result = ret;
                            if (this.executed == null) {
                                this.executed = new ArrayList();
                            }
                            this.executed.add(entry);
                            continue;
                        }
                        if (entry.listener == null) continue;
                        RuntimeException e = new RuntimeException("Invalid action.");
                        if (wakeup) {
                            entry.listener.exceptionOccurred((Exception)e);
                            continue;
                        }
                        entry.exception = e;
                        if (this.executed == null) {
                            this.executed = new ArrayList();
                        }
                        this.executed.add(entry);
                    }
                    catch (Exception e) {
                        if (entry.listener == null) continue;
                        if (wakeup) {
                            entry.listener.exceptionOccurred(e);
                            continue;
                        }
                        entry.exception = e;
                        if (this.executed == null) {
                            this.executed = new ArrayList();
                        }
                        this.executed.add(entry);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void wakeupComponents(IFilter filter) {
        if (this.executed != null && !this.executed.isEmpty()) {
            Iterator it = this.executed.iterator();
            while (it.hasNext()) {
                ActionEntry entry = (ActionEntry)it.next();
                try {
                    if (filter != null && !filter.filter((Object)entry)) continue;
                    it.remove();
                    if (entry.exception == null) {
                        entry.listener.resultAvailable(entry.result);
                        continue;
                    }
                    entry.listener.exceptionOccurred(entry.exception);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setScheduleCommand(ICommand cmd) {
        if (this.cmd != null) {
            throw new RuntimeException("Can set command only once");
        }
        this.cmd = cmd;
    }

    public static class ActionEntry
    implements Comparable {
        protected static int CNT = 0;
        public ISpaceAction action;
        public Map parameters;
        public IResultListener listener;
        public Object result;
        public Exception exception;
        public int id;
        public boolean invalid;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActionEntry(ISpaceAction action, Map parameters, IResultListener listener) {
            this.action = action;
            this.parameters = parameters;
            this.listener = listener;
            Class<ActionEntry> clazz = ActionEntry.class;
            synchronized (ActionEntry.class) {
                this.id = CNT++;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        public int compareTo(Object obj) {
            return this.id - ((ActionEntry)obj).id;
        }

        public String toString() {
            return "" + this.action + this.parameters;
        }
    }
}

