/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment;

import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.commons.IFilter;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.IPerceptProcessor;
import jadex.extension.envsupport.environment.ISpaceObject;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public class PerceptList {
    protected IEnvironmentSpace space;
    protected Set percepts;

    public PerceptList(IEnvironmentSpace space) {
        this.space = space;
    }

    public void schedulePercept(String type, Object data, IComponentDescription component, ISpaceObject avatar, IPerceptProcessor processor) {
        if (this.percepts == null) {
            this.percepts = new LinkedHashSet();
        }
        this.percepts.add(new PerceptEntry(type, data, component, avatar, processor));
    }

    public void setOrdering(Comparator comp) {
        if (this.percepts != null) {
            TreeSet tmp = new TreeSet(comp);
            tmp.addAll(this.percepts);
            this.percepts = tmp;
        } else {
            this.percepts = new TreeSet(comp);
        }
    }

    public void processPercepts(IFilter filter) {
        if (this.percepts != null && !this.percepts.isEmpty()) {
            Iterator it = this.percepts.iterator();
            while (it.hasNext()) {
                PerceptEntry entry = (PerceptEntry)it.next();
                try {
                    if (filter != null && !filter.filter((Object)entry)) continue;
                    it.remove();
                    try {
                        entry.processor.processPercept(this.space, entry.type, entry.data, entry.component, entry.avatar);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class PerceptEntry {
        public String type;
        public Object data;
        public IComponentDescription component;
        public ISpaceObject avatar;
        public IPerceptProcessor processor;

        public PerceptEntry(String type, Object data, IComponentDescription component, ISpaceObject avatar, IPerceptProcessor processor) {
            this.type = type;
            this.data = data;
            this.component = component;
            this.avatar = avatar;
            this.processor = processor;
        }
    }
}

