/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment;

import jadex.bridge.ComponentTerminatedException;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.IServiceProvider;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.clock.ITimedObject;
import jadex.bridge.service.types.clock.ITimer;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.commons.ICommand;
import jadex.commons.SimplePropertyObject;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.dataview.IDataView;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.ComponentActionList;
import jadex.extension.envsupport.environment.ISpaceExecutor;
import jadex.extension.envsupport.environment.ISpaceProcess;
import jadex.extension.envsupport.environment.SpaceObject;
import jadex.extension.envsupport.evaluation.ITableDataConsumer;
import java.util.Comparator;

public class RoundBasedExecutor
extends SimplePropertyObject
implements ISpaceExecutor {
    public static final String PROPERTY_MODE = "mode";
    public static final String MODE_LASTACTION = "lastaction";
    protected long timestamp;
    protected long currenttime;
    protected ITimer timer;
    protected boolean terminated;

    public RoundBasedExecutor() {
    }

    public RoundBasedExecutor(AbstractEnvironmentSpace space) {
        this(space, null);
    }

    public RoundBasedExecutor(AbstractEnvironmentSpace space, Comparator acomp) {
        this.setProperty("space", space);
        this.setProperty("comparator", acomp);
    }

    @Override
    public void start() {
        final AbstractEnvironmentSpace space = (AbstractEnvironmentSpace)this.getProperty("space");
        IServiceProvider provider = space.getExternalAccess().getServiceProvider();
        SServiceProvider.getService((IServiceProvider)provider, IClockService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                final IClockService clockservice = (IClockService)result;
                Comparator comp = (Comparator)RoundBasedExecutor.this.getProperty("comparator");
                if (comp != null) {
                    space.getComponentActionList().setOrdering(comp);
                }
                if (RoundBasedExecutor.MODE_LASTACTION.equals(RoundBasedExecutor.this.getProperty(RoundBasedExecutor.PROPERTY_MODE))) {
                    space.getComponentActionList().setScheduleCommand(new ICommand(){

                        public void execute(Object args) {
                            ComponentActionList.ActionEntry entry = (ComponentActionList.ActionEntry)args;
                            ComponentActionList.ActionEntry[] entries = space.getComponentActionList().getActionEntries();
                            if (entries.length > 0) {
                                IComponentDescription actor = entry.parameters != null ? (IComponentDescription)entry.parameters.get("actor_id") : null;
                                for (int i = 0; actor != null && i < entries.length; ++i) {
                                    IComponentDescription actor2;
                                    IComponentDescription iComponentDescription = actor2 = entries[i].parameters != null ? (IComponentDescription)entries[i].parameters.get("actor_id") : null;
                                    if (!actor.equals(actor2)) continue;
                                    space.getComponentActionList().removeComponentAction(entries[i]);
                                }
                            }
                            space.getComponentActionList().addComponentAction(entry);
                        }
                    });
                }
                RoundBasedExecutor.this.timestamp = clockservice.getTime();
                Object[] procs = space.getProcesses().toArray();
                for (int i = 0; i < procs.length; ++i) {
                    ISpaceProcess process = (ISpaceProcess)procs[i];
                    process.start(clockservice, space);
                }
                new IComponentStep<Void>(){
                    boolean first = true;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public IFuture<Void> execute(IInternalAccess ia) {
                        long progress = RoundBasedExecutor.this.currenttime - RoundBasedExecutor.this.timestamp;
                        RoundBasedExecutor.this.timestamp = RoundBasedExecutor.this.currenttime;
                        Object object = space.getMonitor();
                        synchronized (object) {
                            if (!this.first) {
                                Object[] objs = space.getSpaceObjectsCollection().toArray();
                                for (int i = 0; i < objs.length; ++i) {
                                    SpaceObject obj = (SpaceObject)objs[i];
                                    obj.updateObject(space, progress, clockservice);
                                }
                                space.getComponentActionList().executeActions(null, false);
                                Object[] procs = space.getProcesses().toArray();
                                for (int i = 0; i < procs.length; ++i) {
                                    ISpaceProcess process = (ISpaceProcess)procs[i];
                                    process.execute(clockservice, space);
                                }
                                for (IDataView view : space.getViews()) {
                                    view.update(space);
                                }
                                for (ITableDataConsumer consumer : space.getDataConsumers()) {
                                    consumer.consumeData(RoundBasedExecutor.this.currenttime, clockservice.getTick());
                                }
                            }
                            space.getPerceptList().processPercepts(null);
                            space.getComponentActionList().wakeupComponents(null);
                            this.first = false;
                        }
                        final 2 step = this;
                        RoundBasedExecutor.this.timer = clockservice.createTickTimer(new ITimedObject(){

                            public void timeEventOccurred(long currenttime) {
                                if (!RoundBasedExecutor.this.terminated) {
                                    RoundBasedExecutor.this.currenttime = currenttime;
                                    try {
                                        space.getExternalAccess().scheduleStep(step);
                                    }
                                    catch (ComponentTerminatedException componentTerminatedException) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                        return IFuture.DONE;
                    }
                }.execute(null);
            }
        });
    }

    @Override
    public void terminate() {
        this.terminated = true;
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

