/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment;

import jadex.bridge.service.annotation.Reference;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.IValueFetcher;
import jadex.commons.SReflect;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.MObjectType;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.IObjectTask;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.SynchronizedPropertyObject;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Reference
public class SpaceObject
extends SynchronizedPropertyObject
implements ISpaceObject {
    protected Object id;
    protected String typename;
    protected Map tasks;
    protected MultiCollection tasklisteners;
    protected SimpleValueFetcher fetcher;
    protected AbstractEnvironmentSpace space;

    public SpaceObject(Object id, MObjectType type, Map properties, List tasks, Object monitor, AbstractEnvironmentSpace space) {
        super(type, monitor);
        this.id = id;
        this.typename = type.getName();
        this.properties = properties;
        this.space = space;
        this.tasks = new LinkedHashMap();
        if (tasks != null) {
            for (IObjectTask task : tasks) {
                this.tasks.put(task.getProperty("task_id"), task);
            }
        }
        this.fetcher = new SimpleValueFetcher((IValueFetcher)space.getFetcher());
        this.fetcher.setValue("$object", (Object)this);
    }

    public SpaceObject() {
        super(null, new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String name) {
        Object object = this.monitor;
        synchronized (object) {
            Object ret = super.getProperty(name);
            if (ret instanceof IParsedExpression) {
                ret = ((IParsedExpression)ret).getValue((IValueFetcher)this.fetcher);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name, Object value) {
        Object oldvalue;
        Object object = this.getMonitor();
        synchronized (object) {
            oldvalue = super.getProperty(name);
            super.setProperty(name, value);
        }
        this.space.fireObjectEvent(this, name, oldvalue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getId() {
        Object object = this.monitor;
        synchronized (object) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setId(Object id) {
        Object object = this.monitor;
        synchronized (object) {
            this.id = id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getType() {
        Object object = this.monitor;
        synchronized (object) {
            return this.typename;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(String type) {
        Object object = this.monitor;
        synchronized (object) {
            this.typename = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(IObjectTask task) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.tasks.containsKey(task.getProperty("task_id"))) {
                throw new RuntimeException("Task already exists: " + this + ", " + task);
            }
            task.start(this);
            this.tasks.put(task.getProperty("task_id"), task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Object taskid, Exception e) {
        Object object = this.monitor;
        synchronized (object) {
            IObjectTask task;
            if (this.tasklisteners != null && this.tasklisteners.containsKey(taskid)) {
                Collection listeners = this.tasklisteners.getCollection(taskid);
                Iterator it = listeners.iterator();
                while (it.hasNext()) {
                    if (e == null) {
                        ((IResultListener)it.next()).resultAvailable(taskid);
                        continue;
                    }
                    ((IResultListener)it.next()).exceptionOccurred(e);
                }
                this.tasklisteners.remove(taskid);
                if (this.tasklisteners.isEmpty()) {
                    this.tasklisteners = null;
                }
            }
            if ((task = this.getTask(taskid)) != null) {
                try {
                    task.shutdown(this);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.tasks.remove(taskid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTasks() {
        Object object = this.monitor;
        synchronized (object) {
            return this.tasks.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectTask getTask(Object id) {
        Object object = this.monitor;
        synchronized (object) {
            return (IObjectTask)this.tasks.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTasks() {
        Object object = this.monitor;
        synchronized (object) {
            IObjectTask[] atasks = this.tasks.values().toArray(new IObjectTask[this.tasks.size()]);
            for (int i = 0; i < atasks.length; ++i) {
                this.removeTask(atasks[i], null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(Object taskid, IResultListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.tasks.containsKey(taskid)) {
                if (this.tasklisteners == null) {
                    this.tasklisteners = new MultiCollection();
                }
                this.tasklisteners.put(taskid, (Object)listener);
            } else {
                listener.resultAvailable(taskid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(Object taskid, IResultListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.tasklisteners != null) {
                this.tasklisteners.remove(taskid, (Object)listener);
                if (this.tasklisteners.isEmpty()) {
                    this.tasklisteners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(IEnvironmentSpace space, long progress, IClockService clock) {
        Object object = this.monitor;
        synchronized (object) {
            IObjectTask[] atasks = this.tasks.values().toArray(new IObjectTask[this.tasks.size()]);
            for (int i = 0; i < atasks.length; ++i) {
                try {
                    if (!atasks[i].isFinished(space, this)) {
                        atasks[i].execute(space, this, progress, clock);
                        continue;
                    }
                    this.removeTask(atasks[i].getProperty("task_id"), null);
                    continue;
                }
                catch (Exception e) {
                    if (this.tasklisteners != null && this.tasklisteners.containsKey(atasks[i].getProperty("task_id"))) {
                        Collection listeners = this.tasklisteners.getCollection(atasks[i].getProperty("task_id"));
                        Iterator it = listeners.iterator();
                        while (it.hasNext()) {
                            ((IResultListener)it.next()).exceptionOccurred(e);
                        }
                        this.tasklisteners.remove(atasks[i].getProperty("task_id"));
                        if (this.tasklisteners.isEmpty()) {
                            this.tasklisteners = null;
                        }
                    }
                    this.removeTask(atasks[i].getProperty("task_id"), e);
                }
            }
        }
    }

    public Map getProperties() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String prop : this.getPropertyNames()) {
            ret.put(prop, this.getProperty(prop));
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(id=");
        buf.append(this.getId());
        buf.append(", type=");
        buf.append(this.getType());
        buf.append(", properties=");
        buf.append(this.properties);
        buf.append(", tasks=");
        buf.append(this.tasks);
        buf.append(")");
        return buf.toString();
    }
}

