/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment.space2d;

import jadex.commons.IFilter;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.KdNode;
import jadex.extension.envsupport.math.IVector2;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class KdTree {
    protected static final int DEFAULT_MAX_LEAF_NODE_SIZE = 6;
    protected static final int DEFAULT_MAX_MEDIAN_SAMPLES = 10;
    List<ISpaceObject> objects = new ArrayList<ISpaceObject>();
    protected KdNode rootNode;
    protected Random random = new Random();
    protected int maxLeafNodeSize;
    protected int maxMedianSamples;

    public KdTree() {
        this(6, 10);
    }

    public KdTree(int maxLeafNodeSize, int maxMedianSamples) {
        this.maxLeafNodeSize = maxLeafNodeSize;
        this.maxMedianSamples = maxMedianSamples;
    }

    public List<ISpaceObject> getNearestObjects(IVector2 point, double radius) {
        return this.getNearestObjects(point, radius, null);
    }

    public List<ISpaceObject> getNearestObjects(IVector2 point, double radius, IFilter filter) {
        return this.rootNode != null ? this.rootNode.getNearestObjects(point, radius * radius, filter) : new ArrayList<ISpaceObject>();
    }

    public ISpaceObject getNearestObject(IVector2 point) {
        return this.rootNode != null ? this.rootNode.getNearestObject(point, Double.MAX_VALUE) : null;
    }

    public ISpaceObject getNearestObject(IVector2 point, IFilter filter) {
        return this.rootNode != null ? this.rootNode.getNearestObject(point, Double.MAX_VALUE, filter) : null;
    }

    public ISpaceObject getNearestObject(IVector2 point, double searchRadius) {
        return this.getNearestObject(point, searchRadius, null);
    }

    public ISpaceObject getNearestObject(IVector2 point, double searchRadius, IFilter filter) {
        double sr2;
        ISpaceObject ret = null;
        if (this.rootNode != null && (ret = this.rootNode.getNearestObject(point, sr2 = searchRadius * searchRadius, filter)) != null && KdNode.getDistance(ret, point).getSquaredLength().getAsDouble() > sr2) {
            return null;
        }
        return ret;
    }

    public void addObject(ISpaceObject obj) {
        this.objects.add(obj);
    }

    public void removeObject(ISpaceObject obj) {
        int index = this.objects.indexOf(obj);
        if (index == -1) {
            return;
        }
        if (this.objects.size() > 1) {
            this.objects.set(index, this.objects.get(this.objects.size() - 1));
            this.objects.remove(this.objects.size() - 1);
        } else {
            this.objects.clear();
        }
    }

    public void rebuild() {
        this.rootNode = this.objects != null && !this.objects.isEmpty() ? new KdNode(this.objects, this.random) : null;
    }
}

