/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment.space2d;

import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.IFilter;
import jadex.commons.SimplePropertyObject;
import jadex.commons.meta.IPropertyMetaDataSet;
import jadex.extension.envsupport.MObjectType;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.ISpaceProcess;
import jadex.extension.envsupport.environment.space2d.KdTree;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.math.Vector2Int;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Space2D
extends AbstractEnvironmentSpace {
    public static final String PROPERTY_POSITION = "position";
    public static final String PROPERTY_BORDER = "border";
    public static final String BORDER_STRICT = "strict";
    public static final String BORDER_TORUS = "torus";
    protected IVector2 areasize;
    protected Map<String, KdTree> kdTrees;

    protected Space2D(IVector2 areasize) {
        this.areasize = areasize;
        this.kdTrees = new HashMap<String, KdTree>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector2 getAreaSize() {
        Object object = this.monitor;
        synchronized (object) {
            return this.areasize.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAreaSize(IVector2 areasize) {
        Object object = this.monitor;
        synchronized (object) {
            this.areasize = areasize;
        }
    }

    public String getBorderMode() {
        return this.getPropertyNames().contains(PROPERTY_BORDER) ? (String)this.getProperty(PROPERTY_BORDER) : BORDER_TORUS;
    }

    @Override
    public void initSpaceObject(ISpaceObject ret) {
        KdTree kdTree;
        IVector2 pos;
        super.initSpaceObject(ret);
        IVector2 iVector2 = pos = ret.getPropertyNames().contains(PROPERTY_POSITION) ? (IVector2)ret.getProperty(PROPERTY_POSITION) : this.getRandomPosition(Vector2Int.ZERO);
        if (pos != null) {
            ret.setProperty(PROPERTY_POSITION, null);
            this.setPosition(ret.getId(), pos);
        }
        if ((kdTree = this.kdTrees.get(ret.getType())) != null) {
            kdTree.addObject(ret);
        }
    }

    @Override
    public void addSpaceObjectType(String typename, IPropertyMetaDataSet mobjecttype) {
        super.addSpaceObjectType(typename, mobjecttype);
        if (((MObjectType)mobjecttype).isKdTree()) {
            this.enableKdTree(typename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(Object id, IVector2 pos) {
        Object object = this.monitor;
        synchronized (object) {
            ISpaceObject obj = this.getSpaceObject(id);
            if (obj == null) {
                throw new RuntimeException("Space object not found: " + id);
            }
            IVector2 newpos = this.adjustPosition(pos);
            obj.setProperty(PROPERTY_POSITION, newpos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector1 getDistance(IVector2 pos1, IVector2 pos2) {
        Object object = this.monitor;
        synchronized (object) {
            IVector1 dx = this.getDistance(pos1.getX(), pos2.getX(), true);
            IVector1 dy = this.getDistance(pos1.getY(), pos2.getY(), false);
            IVector1 ret = this.calculateDistance(dx, dy);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector1 getDistance(IVector1 pos1, IVector1 pos2, boolean isx) {
        Object object = this.monitor;
        synchronized (object) {
            IVector1 ret = null;
            if (this.getBorderMode() == BORDER_TORUS) {
                IVector1 d2;
                IVector1 d1;
                IVector1 size;
                IVector1 iVector1 = size = isx ? this.areasize.getX() : this.areasize.getY();
                if (pos1.greater(pos2)) {
                    IVector1 tmp = pos1;
                    pos1 = pos2;
                    pos2 = tmp;
                }
                ret = (d1 = pos2.copy().subtract(pos1)).less(d2 = pos1.copy().add(size).subtract(pos2)) ? d1 : d2;
            } else {
                ret = pos1.getDistance(pos2);
            }
            return ret;
        }
    }

    public IVector1 calculateDistance(IVector1 dx, IVector1 dy) {
        IVector1 x2 = dx.copy().multiply(dx);
        IVector1 y2 = dy.copy().multiply(dy);
        return x2.add(y2).sqrt();
    }

    public IVector2 adjustPosition(IVector2 pos) {
        IVector2 ret = null;
        if (pos != null) {
            if (BORDER_TORUS.equals(this.getBorderMode())) {
                IVector1 sizex = this.areasize.getX();
                IVector1 sizey = this.areasize.getY();
                IVector1 x = pos.getX().copy();
                IVector1 y = pos.getY().copy();
                while (x.less(Vector1Double.ZERO)) {
                    x.add(sizex);
                }
                while (y.less(Vector1Double.ZERO)) {
                    y.add(sizey);
                }
                x = x.copy().mod(sizex);
                y = y.copy().mod(sizey);
                ret = x.createVector2(y);
            } else if (BORDER_STRICT.equals(this.getBorderMode())) {
                IVector1 sizex = this.areasize.getX();
                IVector1 sizey = this.areasize.getY();
                if (pos.getX().greater(sizex) || pos.getX().less(Vector1Double.ZERO) || pos.getY().greater(sizey) || pos.getY().less(Vector1Double.ZERO)) {
                    throw new RuntimeException("Position out of areasize: " + pos + " " + this.areasize);
                }
                ret = pos;
            } else {
                throw new RuntimeException("Unknown bordermode: " + this.getBorderMode());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector2 getRandomPosition(IVector2 distance) {
        Object object = this.monitor;
        synchronized (object) {
            if (distance == null) {
                distance = Vector2Double.ZERO;
            }
            IVector2 position = this.areasize.copy();
            position.subtract(distance);
            position.randomX(distance.getX(), position.getX());
            position.randomY(distance.getY(), position.getY());
            return position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableKdTree(String type) {
        Object object = this.monitor;
        synchronized (object) {
            KdTree tree = new KdTree();
            ISpaceObject[] objects = this.getSpaceObjectsByType(type);
            for (int i = 0; i < objects.length; ++i) {
                tree.addObject(objects[i]);
            }
            tree.rebuild();
            this.kdTrees.put(type, tree);
            KdTreeProcess process = new KdTreeProcess(tree);
            process.setProperty("##_id", tree);
            this.processes.put(tree, process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableKdTree(String type) {
        Object object = this.monitor;
        synchronized (object) {
            KdTree tree = this.kdTrees.remove(type);
            this.processes.remove(tree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISpaceObject getNearestObject(IVector2 position, IVector1 maxdist, String type) {
        ISpaceObject ret = null;
        Object object = this.monitor;
        synchronized (object) {
            KdTree kdTree = this.kdTrees.get(type);
            if (kdTree != null) {
                return kdTree.getNearestObject(position, maxdist.getAsDouble());
            }
            ISpaceObject nearest = null;
            IVector1 distance = null;
            ISpaceObject[] objects = type != null ? this.getSpaceObjectsByType(type) : (ISpaceObject[])this.getSpaceObjects();
            for (int i = 0; objects != null && i < objects.length; ++i) {
                IVector2 curpos = (IVector2)objects[i].getProperty(PROPERTY_POSITION);
                if (curpos == null) continue;
                IVector1 objdist = this.getDistance(curpos, position);
                if (nearest != null && !objdist.less(distance)) continue;
                nearest = objects[i];
                distance = objdist;
            }
            if (maxdist == null || distance != null && !maxdist.less(distance)) {
                ret = nearest;
            }
            return ret;
        }
    }

    public Set getNearObjects(IVector2 position, IVector1 maxdist) {
        return this.getNearObjects(position, maxdist, (IFilter)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getNearObjects(IVector2 position, IVector1 maxdist, final String type) {
        Object object = this.monitor;
        synchronized (object) {
            KdTree kdTree = this.kdTrees.get(type);
            if (kdTree != null) {
                return new HashSet<ISpaceObject>(kdTree.getNearestObjects(position, maxdist.getAsDouble()));
            }
        }
        return this.getNearObjects(position, maxdist, new IFilter(){

            public boolean filter(Object obj) {
                return type.equals(((ISpaceObject)obj).getType());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getNearObjects(IVector2 position, IVector1 maxdist, IFilter filter) {
        Object object = this.monitor;
        synchronized (object) {
            HashSet<ISpaceObject> ret = new HashSet<ISpaceObject>();
            Set objects = this.spaceobjects.entrySet();
            for (Map.Entry entry : objects) {
                ISpaceObject obj = (ISpaceObject)entry.getValue();
                IVector2 pos = (IVector2)obj.getProperty(PROPERTY_POSITION);
                if (pos == null || filter != null && !filter.filter((Object)obj)) continue;
                IVector1 dist = this.getDistance(pos, position);
                if (maxdist != null && maxdist.less(dist)) continue;
                ret.add(obj);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getNearObjects(IVector2 position, IVector1 maxdist, final String type, final IFilter filter) {
        Object object = this.monitor;
        synchronized (object) {
            KdTree kdTree = this.kdTrees.get(type);
            if (kdTree != null) {
                return new HashSet<ISpaceObject>(kdTree.getNearestObjects(position, maxdist.getAsDouble(), filter));
            }
        }
        return this.getNearObjects(position, maxdist, new IFilter(){

            public boolean filter(Object obj) {
                return ((ISpaceObject)obj).getType().equals(type) && filter.filter(obj);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSpaceObjects() {
        Object object = this.monitor;
        synchronized (object) {
            return this.spaceobjects.values().toArray();
        }
    }

    protected class KdTreeProcess
    extends SimplePropertyObject
    implements ISpaceProcess {
        protected KdTree kdtree;

        public KdTreeProcess(KdTree kdTree) {
            this.kdtree = kdTree;
        }

        @Override
        public void execute(IClockService clock, IEnvironmentSpace space) {
            this.kdtree.rebuild();
        }

        @Override
        public void shutdown(IEnvironmentSpace space) {
        }

        @Override
        public void start(IClockService clock, IEnvironmentSpace space) {
        }
    }
}

