/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment.space3d;

import jadex.commons.collection.MultiCollection;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space3d.Space3D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector3;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector1Int;
import jadex.extension.envsupport.math.Vector3Int;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Grid3D
extends Space3D {
    public static final String DEFAULT_NAME = Grid3D.class.getName();
    public static final String NEIGHBORHOOD_MOORE = "moore";
    public static final String NEIGHBORHOOD_VON_NEUMANN = "von_neumann";
    public static final String PROPERTY_NEIGHBORHOOD = "neighborhood";
    protected MultiCollection objectsygridpos;

    public Grid3D() {
        this(null);
    }

    public Grid3D(IVector3 areasize) {
        this(DEFAULT_NAME, areasize);
    }

    public Grid3D(Object name, IVector3 areasize) {
        super(areasize == null ? null : new Vector3Int(areasize.getXAsInteger(), areasize.getYAsInteger(), areasize.getZAsInteger()));
        this.setProperty("name", name);
        this.objectsygridpos = new MultiCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAreaSize(IVector3 areasize) {
        Object object = this.monitor;
        synchronized (object) {
            this.areasize = areasize == null ? null : new Vector3Int(areasize.getXAsInteger(), areasize.getYAsInteger(), areasize.getZAsInteger());
        }
    }

    public String getNeighborhood() {
        return this.getPropertyNames().contains(PROPERTY_NEIGHBORHOOD) ? (String)this.getProperty(PROPERTY_NEIGHBORHOOD) : NEIGHBORHOOD_VON_NEUMANN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSpaceObjectsByGridPosition(IVector3 position, Object type) {
        ArrayList<ISpaceObject> ret = null;
        Object object = this.monitor;
        synchronized (object) {
            if (position != null) {
                position = this.adjustPosition(position);
                Vector3Int fieldpos = new Vector3Int(position.getXAsInteger(), position.getYAsInteger(), position.getZAsInteger());
                ArrayList<ISpaceObject> simobjs = this.objectsygridpos.getCollection((Object)fieldpos);
                if (null == type) {
                    ret = simobjs;
                } else {
                    ArrayList<ISpaceObject> tmp = new ArrayList<ISpaceObject>();
                    for (ISpaceObject curobj : simobjs) {
                        if (!type.equals(curobj.getType())) continue;
                        tmp.add(curobj);
                    }
                    if (tmp.size() > 0) {
                        ret = tmp;
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector3 getEmptyGridPosition() {
        Object object = this.monitor;
        synchronized (object) {
            Vector3Int ret = null;
            int n = 5;
            for (int i = 0; i < n && ret == null; ++i) {
                ret = new Vector3Int(this.getRandomPosition(Vector3Int.ZERO));
                if (!this.objectsygridpos.containsKey((Object)ret)) continue;
                ret = null;
            }
            if (ret == null) {
                for (int y = 0; ret == null && y < this.areasize.getYAsInteger(); ++y) {
                    for (int x = 0; ret == null && x < this.areasize.getXAsInteger(); ++x) {
                        int z = 0;
                        while (ret == null && x < this.areasize.getZAsInteger()) {
                            ret = new Vector3Int(x, y, z);
                            if (this.objectsygridpos.containsKey((Object)ret)) {
                                ret = null;
                            }
                            ++z;
                        }
                    }
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPosition(Object id, IVector3 pos) {
        Object object = this.monitor;
        synchronized (object) {
            IVector3 newpos;
            ISpaceObject obj = this.getSpaceObject(id);
            IVector3 oldpos = (IVector3)obj.getProperty("position");
            if (oldpos != null && this.objectsygridpos.containsKey((Object)(oldpos = new Vector3Int(oldpos.getXAsInteger(), oldpos.getYAsInteger(), oldpos.getZAsInteger())))) {
                this.objectsygridpos.remove((Object)oldpos, (Object)obj);
            }
            if ((newpos = this.adjustPosition(pos)) != null) {
                this.objectsygridpos.put((Object)new Vector3Int(newpos.getXAsInteger(), newpos.getYAsInteger(), newpos.getZAsInteger()), (Object)obj);
            }
            super.setPosition(id, newpos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initSpaceObject(ISpaceObject ret) {
        Object object = this.monitor;
        synchronized (object) {
            IVector3 pos;
            if (!ret.getPropertyNames().contains("position") && (pos = this.getEmptyGridPosition()) != null) {
                ret.setProperty("position", pos);
            }
            super.initSpaceObject(ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySpaceObject(Object id) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                IVector3 pos = (IVector3)this.getSpaceObject(id).getProperty("position");
                if (pos != null) {
                    Vector3Int fieldpos = new Vector3Int(pos.getXAsInteger(), pos.getYAsInteger(), pos.getZAsInteger());
                    this.objectsygridpos.remove((Object)fieldpos, this.spaceobjects.get(id));
                }
                super.destroySpaceObject(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getNearObjects(IVector3 position, IVector1 distance, String type) {
        Object object = this.monitor;
        synchronized (object) {
            HashSet<ISpaceObject> ret = new HashSet<ISpaceObject>();
            int sizex = this.areasize.getXAsInteger();
            int sizey = this.areasize.getYAsInteger();
            int sizez = this.areasize.getZAsInteger();
            int x = position.getXAsInteger();
            int y = position.getYAsInteger();
            int z = position.getYAsInteger();
            Vector3Int pos = new Vector3Int(x, y, z);
            int range = distance.getAsInteger();
            int minx = x - range >= 0 || this.getBorderMode().equals("torus") ? x - range : 0;
            int maxx = x + range <= sizex || this.getBorderMode().equals("torus") ? x + range : sizex;
            int miny = y - range >= 0 || this.getBorderMode().equals("torus") ? y - range : 0;
            int maxy = y + range <= sizey || this.getBorderMode().equals("torus") ? y + range : sizey;
            int minz = z - range >= 0 || this.getBorderMode().equals("torus") ? z - range : 0;
            int maxz = z + range <= sizez || this.getBorderMode().equals("torus") ? z + range : sizez;
            for (int i = minx; i <= maxx; ++i) {
                for (int j = miny; j <= maxy; ++j) {
                    int k = minz;
                    while (k <= maxz) {
                        Collection tmp;
                        Vector3Int testpos = new Vector3Int((i + sizex) % sizex, (j + sizey) % sizey, (k + sizez) % sizez);
                        if (!this.getDistance(testpos, pos).greater(distance) && (tmp = this.objectsygridpos.getCollection((Object)testpos)) != null) {
                            if (type == null) {
                                ret.addAll(tmp);
                            } else {
                                for (ISpaceObject obj : tmp) {
                                    if (!obj.getType().equals(type)) continue;
                                    ret.add(obj);
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            return ret;
        }
    }

    public IVector1 calculateDistance(IVector1 dx, IVector1 dy) {
        if (NEIGHBORHOOD_MOORE.equals(this.getNeighborhood())) {
            return dx.greater(dy) ? dx : dy;
        }
        if (NEIGHBORHOOD_VON_NEUMANN.equals(this.getNeighborhood())) {
            if (dx.less(Vector1Double.ZERO)) {
                dx = dx.copy().negate();
            }
            if (dy.less(Vector1Double.ZERO)) {
                dy = dy.copy().negate();
            }
        }
        return dx.add(dy);
    }

    public IVector1 getShortestDirection(IVector1 pos1, IVector1 pos2, boolean isx) {
        IVector1 ret = Vector1Int.ZERO;
        if (this.getBorderMode().equals("torus")) {
            IVector1 size;
            IVector1 iVector1 = size = isx ? this.areasize.getX() : this.areasize.getY();
            if (pos1.less(pos2)) {
                IVector1 d2;
                IVector1 d1 = pos2.copy().subtract(pos1);
                ret = d1.less(d2 = pos1.copy().add(size).subtract(pos2)) ? new Vector1Int(1) : new Vector1Int(-1);
            } else if (pos1.greater(pos2)) {
                IVector1 d2;
                IVector1 d1 = pos1.copy().subtract(pos2);
                ret = d1.less(d2 = pos2.copy().add(size).subtract(pos1)) ? new Vector1Int(-1) : new Vector1Int(1);
            }
        } else if (pos1.less(pos2)) {
            ret = new Vector1Int(1);
        } else if (pos1.greater(pos2)) {
            ret = new Vector1Int(-1);
        }
        return ret;
    }
}

