/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import jadex.commons.IValueFetcher;
import jadex.commons.ResourceInfo;
import jadex.commons.SUtil;
import jadex.commons.SimplePropertyObject;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.evaluation.DataTable;
import jadex.extension.envsupport.evaluation.ITableDataConsumer;
import jadex.extension.envsupport.evaluation.ITableDataProvider;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.io.IOException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public abstract class AbstractChartDataConsumer
extends SimplePropertyObject
implements ITableDataConsumer {
    protected JFreeChart chart;

    @Override
    public void consumeData(long currenttime, double tick) {
        ITableDataProvider provider = this.getTableDataProvider();
        final DataTable data = provider.getTableData(currenttime, tick);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List rows = data.getRows();
                if (rows != null && rows.size() > 0) {
                    SimpleValueFetcher fetcher = new SimpleValueFetcher();
                    fetcher.setValue("$object", (Object)data);
                    int s = 0;
                    while (true) {
                        Object[] values;
                        Object[] row;
                        String serid;
                        if ((serid = s == 0 && AbstractChartDataConsumer.this.getPropertyNames().contains("seriesid") ? (String)AbstractChartDataConsumer.this.getProperty("seriesid") : (String)AbstractChartDataConsumer.this.getProperty("seriesid_" + s)) != null) {
                            for (int i = 0; i < rows.size(); ++i) {
                                fetcher.setValue("$rowcnt", (Object)new Integer(i));
                                row = (Object[])rows.get(i);
                                values = AbstractChartDataConsumer.this.getValues(s, data, row, fetcher);
                                Comparable sername = (Comparable)row[data.getColumnIndex(serid)];
                                AbstractChartDataConsumer.this.addValue(sername, values[0], values[1], data, row);
                            }
                        } else {
                            String sername = s == 0 && AbstractChartDataConsumer.this.getPropertyNames().contains("seriesname") ? (String)AbstractChartDataConsumer.this.getProperty("seriesname") : (String)AbstractChartDataConsumer.this.getProperty("seriesname_" + s);
                            if (sername == null) break;
                            fetcher.setValue("$rowcnt", (Object)new Integer(0));
                            row = (Object[])rows.get(0);
                            values = AbstractChartDataConsumer.this.getValues(s, data, row, fetcher);
                            AbstractChartDataConsumer.this.addValue((Comparable)((Object)sername), values[0], values[1], data, row);
                        }
                        ++s;
                    }
                }
            }
        });
    }

    protected Object[] getValues(int num, DataTable data, Object[] row, SimpleValueFetcher fetcher) {
        Object valuex = num == 0 && this.getPropertyNames().contains("valuex") ? this.getProperty("valuex") : this.getProperty("valuex_" + num);
        Object valuey = num == 0 && this.getPropertyNames().contains("valuey") ? this.getProperty("valuey") : this.getProperty("valuey_" + num);
        Object valx = valuex instanceof String ? (Number)row[data.getColumnIndex((String)valuex)] : ((IParsedExpression)valuex).getValue((IValueFetcher)fetcher);
        Object valy = valuey instanceof String ? (Number)row[data.getColumnIndex((String)valuey)] : ((IParsedExpression)valuey).getValue((IValueFetcher)fetcher);
        return new Object[]{valx, valy};
    }

    public JFreeChart getChart() {
        if (this.chart == null) {
            this.chart = this.createChart();
        }
        return this.chart;
    }

    public void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractChartDataConsumer.this.getChart().fireChartChanged();
            }
        });
    }

    public AbstractEnvironmentSpace getSpace() {
        return (AbstractEnvironmentSpace)this.getProperty("envspace");
    }

    protected ITableDataProvider getTableDataProvider() {
        String providername = (String)this.getProperty("dataprovider");
        ITableDataProvider provider = this.getSpace().getDataProvider(providername);
        if (provider == null) {
            throw new RuntimeException("Data provider nulls: " + providername);
        }
        return provider;
    }

    protected ResourceInfo getResourceInfo(String name, String[] imports, ClassLoader classloader) throws Exception {
        String resstr = name;
        ResourceInfo ret = SUtil.getResourceInfo0((String)resstr, (ClassLoader)classloader);
        if (ret == null || ret.getInputStream() == null) {
            for (int i = 0; (ret == null || ret.getInputStream() == null) && imports != null && i < imports.length; ++i) {
                if (!imports[i].endsWith(".*")) continue;
                resstr = SUtil.replace((String)imports[i].substring(0, imports[i].length() - 1), (String)".", (String)"/") + name;
                ret = SUtil.getResourceInfo0((String)resstr, (ClassLoader)classloader);
            }
        }
        if (ret == null || ret.getInputStream() == null) {
            throw new IOException("File " + name + " not found in imports");
        }
        return ret;
    }

    public JPanel getChartPanel() {
        ChartPanel panel = new ChartPanel(this.getChart(), false, false, false, false, false);
        panel.setFillZoomRectangle(true);
        return panel;
    }

    protected abstract JFreeChart createChart();

    protected abstract void addValue(Comparable var1, Object var2, Object var3, DataTable var4, Object[] var5);
}

