/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import jadex.commons.SimplePropertyObject;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.evaluation.DataTable;
import jadex.extension.envsupport.evaluation.ITableDataConsumer;
import jadex.extension.envsupport.evaluation.ITableDataProvider;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;

public class CSVFileDataConsumer
extends SimplePropertyObject
implements ITableDataConsumer {
    public static final String lf = System.getProperty("line.separator");
    protected Writer writer;

    @Override
    public void consumeData(long time, double tick) {
        try {
            List rows;
            ITableDataProvider provider = this.getTableDataProvider();
            DataTable table = provider.getTableData(time, tick);
            if (this.writer == null) {
                String filename = (String)this.getProperty("filename");
                this.writer = new BufferedWriter(new FileWriter(filename));
                String[] colnames = table.getColumnNames();
                for (int i = 0; i < colnames.length; ++i) {
                    if (i != 0) {
                        this.writer.write(", ");
                    }
                    this.writer.write(colnames[i]);
                    System.out.println(colnames[i]);
                }
                this.writer.write(lf);
            }
            if ((rows = table.getRows()) != null) {
                for (int i = 0; i < rows.size(); ++i) {
                    Object[] row = (Object[])rows.get(i);
                    for (int j = 0; j < row.length; ++j) {
                        if (j != 0) {
                            this.writer.write(", ");
                        }
                        this.writer.write("" + row[j]);
                        System.out.println("" + row[j]);
                    }
                    this.writer.write(lf);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AbstractEnvironmentSpace getSpace() {
        return (AbstractEnvironmentSpace)this.getProperty("envspace");
    }

    protected ITableDataProvider getTableDataProvider() {
        String providername = (String)this.getProperty("dataprovider");
        ITableDataProvider provider = this.getSpace().getDataProvider(providername);
        if (provider == null) {
            throw new RuntimeException("Data provider nulls: " + providername);
        }
        return provider;
    }
}

