/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import jadex.commons.IValueFetcher;
import jadex.commons.SUtil;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.evaluation.IObjectSource;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.util.ArrayList;
import java.util.List;

public class SpaceObjectSource
implements IObjectSource {
    protected String varname;
    protected AbstractEnvironmentSpace envspace;
    protected String objecttype;
    protected boolean aggregate;
    protected IParsedExpression dataexp;
    protected IParsedExpression includeexp;

    public SpaceObjectSource(String varname, AbstractEnvironmentSpace envspace, String objecttype, boolean aggregate, IParsedExpression dataexp, IParsedExpression includeexp) {
        this.varname = varname;
        this.envspace = envspace;
        this.objecttype = objecttype;
        this.aggregate = aggregate;
        this.dataexp = dataexp;
        this.includeexp = includeexp;
    }

    @Override
    public List getObjects() {
        List<Object> ret = new ArrayList();
        ISpaceObject[] obs = this.envspace.getSpaceObjectsByType(this.objecttype);
        if (obs != null) {
            SimpleValueFetcher fetcher;
            if (this.includeexp != null) {
                fetcher = new SimpleValueFetcher();
                for (int i = 0; i < obs.length; ++i) {
                    fetcher.setValue("$object", (Object)obs[i]);
                    if (!((Boolean)this.includeexp.getValue((IValueFetcher)fetcher)).booleanValue()) continue;
                    if (this.dataexp != null) {
                        ret.add(this.dataexp.getValue((IValueFetcher)fetcher));
                        continue;
                    }
                    ret.add(obs[i]);
                }
            } else if (this.dataexp != null) {
                fetcher = new SimpleValueFetcher();
                for (int i = 0; i < obs.length; ++i) {
                    fetcher.setValue("$object", (Object)obs[i]);
                    ret.add(this.dataexp.getValue((IValueFetcher)fetcher));
                }
            } else {
                ret = SUtil.arrayToList((Object)obs);
            }
        }
        if (this.aggregate) {
            ArrayList tmp = ret;
            ret = new ArrayList();
            ret.add(tmp);
        }
        return ret;
    }

    @Override
    public String getSourceName() {
        return this.varname;
    }
}

