/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import jadex.commons.ResourceInfo;
import jadex.extension.envsupport.evaluation.AbstractChartDataConsumer;
import jadex.extension.envsupport.evaluation.DataTable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.VectorSeries;
import org.jfree.data.xy.VectorSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class XYChartDataConsumer
extends AbstractChartDataConsumer {
    protected Map seriesmap = new HashMap();

    @Override
    protected JFreeChart createChart() {
        String title = (String)this.getProperty("title");
        String labelx = (String)this.getProperty("labelx");
        String labely = (String)this.getProperty("labely");
        boolean legend = this.getProperty("legend") == null ? true : (Boolean)this.getProperty("legend");
        boolean tooltips = this.getProperty("tooltips") == null ? true : (Boolean)this.getProperty("tooltips");
        boolean urls = this.getProperty("urls") == null ? false : (Boolean)this.getProperty("urls");
        boolean autorepaint = this.getProperty("autorepaint") == null ? false : (Boolean)this.getProperty("autorepaint");
        VectorSeriesCollection dataset = new VectorSeriesCollection();
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)labelx, (String)labely, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setNotify(autorepaint);
        String bgimagefn = (String)this.getProperty("bgimage");
        if (bgimagefn != null) {
            try {
                ClassLoader cl = this.getSpace().getClassLoader();
                ResourceInfo rinfo = this.getResourceInfo(bgimagefn, this.getSpace().getExternalAccess().getModel().getAllImports(), cl);
                BufferedImage image = ImageIO.read(rinfo.getInputStream());
                rinfo.getInputStream().close();
                chart.getPlot().setBackgroundImage((Image)image);
            }
            catch (Exception e) {
                System.out.println("Background image not found: " + bgimagefn);
            }
        }
        return chart;
    }

    @Override
    protected void addValue(Comparable seriesname, Object valx, Object valy, DataTable data, Object[] row) {
        int seriesnum = 0;
        VectorSeriesCollection dataset = (VectorSeriesCollection)((XYPlot)this.getChart().getPlot()).getDataset();
        int sercnt = dataset.getSeriesCount();
        Integer sernum = (Integer)this.seriesmap.get(seriesname);
        seriesnum = sernum != null ? sernum : sercnt;
        for (int j = sercnt; j <= seriesnum; ++j) {
            VectorSeries series;
            Integer maxitemcnt = (Integer)this.getProperty("maxitemcount");
            if (seriesname != null) {
                series = new VectorSeries(seriesname);
                if (maxitemcnt != null) {
                    series.setMaximumItemCount(maxitemcnt.intValue());
                }
                this.seriesmap.put(seriesname, new Integer(j));
            } else {
                series = new VectorSeries((Comparable)new Integer(j));
                if (maxitemcnt != null) {
                    series.setMaximumItemCount(maxitemcnt.intValue());
                }
                this.seriesmap.put(new Integer(j), new Integer(j));
            }
            dataset.addSeries(series);
        }
        VectorSeries ser = dataset.getSeries(seriesnum);
        ser.add(((Number)valx).doubleValue(), ((Number)valy).doubleValue(), 0.0, 0.0);
    }
}

