/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.math;

import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.IVector3;
import jadex.extension.envsupport.math.Vector1Double;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class Vector3Double
implements IVector3,
Cloneable {
    public static final IVector3 ZERO = new Vector3Double(0.0);
    private double x_;
    private double y_;
    private double z_;

    public Vector3Double() {
        this.x_ = 0.0;
        this.y_ = 0.0;
        this.z_ = 0.0;
    }

    public Vector3Double(IVector3 vector) {
        this.x_ = vector.getXAsDouble();
        this.y_ = vector.getYAsDouble();
        this.z_ = vector.getYAsDouble();
    }

    public Vector3Double(double scalar) {
        this.x_ = scalar;
        this.y_ = scalar;
        this.z_ = scalar;
    }

    public Vector3Double(double x, double y, double z) {
        this.x_ = x;
        this.y_ = y;
        this.z_ = z;
    }

    @Override
    public IVector3 assign(IVector3 vector) {
        this.x_ = vector.getXAsDouble();
        this.y_ = vector.getYAsDouble();
        this.z_ = vector.getZAsDouble();
        return this;
    }

    @Override
    public IVector3 add(double scalar) {
        this.x_ += scalar;
        this.y_ += scalar;
        this.z_ += scalar;
        return this;
    }

    @Override
    public IVector3 add(IVector1 scalar) {
        this.x_ += scalar.getAsDouble();
        this.y_ += scalar.getAsDouble();
        this.z_ += scalar.getAsDouble();
        return this;
    }

    @Override
    public IVector3 add(IVector3 vector) {
        this.x_ += vector.getXAsDouble();
        this.y_ += vector.getYAsDouble();
        this.z_ += vector.getZAsDouble();
        return this;
    }

    @Override
    public IVector3 subtract(double scalar) {
        this.x_ -= scalar;
        this.y_ -= scalar;
        this.z_ -= scalar;
        return this;
    }

    @Override
    public IVector3 subtract(IVector1 scalar) {
        this.x_ -= scalar.getAsDouble();
        this.y_ -= scalar.getAsDouble();
        this.z_ -= scalar.getAsDouble();
        return this;
    }

    @Override
    public IVector3 subtract(IVector3 vector) {
        this.x_ -= vector.getXAsDouble();
        this.y_ -= vector.getYAsDouble();
        this.z_ -= vector.getZAsDouble();
        return this;
    }

    @Override
    public IVector3 mod(IVector3 modulus) {
        double mx = modulus.getXAsDouble();
        double my = modulus.getYAsDouble();
        double mz = modulus.getZAsDouble();
        this.x_ = (this.x_ + mx) % mx;
        this.y_ = (this.y_ + my) % my;
        this.z_ = (this.z_ + mz) % mz;
        return this;
    }

    @Override
    public IVector3 multiply(double scalar) {
        this.x_ *= scalar;
        this.y_ *= scalar;
        this.z_ *= scalar;
        return this;
    }

    @Override
    public IVector3 multiply(IVector1 scalar) {
        this.x_ *= scalar.getAsDouble();
        this.y_ *= scalar.getAsDouble();
        this.z_ *= scalar.getAsDouble();
        return this;
    }

    @Override
    public IVector3 multiply(IVector3 vector) {
        this.x_ *= vector.getXAsDouble();
        this.y_ *= vector.getYAsDouble();
        this.z_ *= vector.getZAsDouble();
        return this;
    }

    @Override
    public IVector3 divide(IVector3 vector) {
        this.x_ /= vector.getXAsDouble();
        this.y_ /= vector.getYAsDouble();
        this.z_ /= vector.getZAsDouble();
        return this;
    }

    @Override
    public IVector3 zero() {
        this.x_ = 0.0;
        this.y_ = 0.0;
        this.z_ = 0.0;
        return this;
    }

    @Override
    public IVector3 negateX() {
        this.x_ = -this.x_;
        return this;
    }

    @Override
    public IVector3 negateY() {
        this.y_ = -this.y_;
        return this;
    }

    @Override
    public IVector3 negateZ() {
        this.z_ = -this.z_;
        return this;
    }

    @Override
    public IVector3 negate() {
        this.x_ = -this.x_;
        this.y_ = -this.y_;
        this.z_ = -this.z_;
        return this;
    }

    @Override
    public IVector3 randomX(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.x_ = r += l;
        return this;
    }

    @Override
    public IVector3 randomY(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.y_ = r += l;
        return this;
    }

    @Override
    public IVector3 randomZ(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.z_ = r += l;
        return this;
    }

    @Override
    public IVector3 normalize() {
        double length = Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_ + this.z_ * this.z_);
        if (length != 0.0) {
            this.x_ /= length;
            this.y_ /= length;
            this.z_ /= length;
        }
        return this;
    }

    @Override
    public IVector1 getLength() {
        return new Vector1Double(Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_ + this.z_ * this.z_));
    }

    @Override
    public IVector2 getDirection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IVector1 getDistance(IVector3 vector) {
        double dx = this.x_ - vector.getXAsDouble();
        double dy = this.y_ - vector.getYAsDouble();
        double dz = this.z_ - vector.getZAsDouble();
        return new Vector1Double(Math.sqrt(dx * dx + dy * dy + dz * dz));
    }

    @Override
    public IVector1 getX() {
        return new Vector1Double(this.x_);
    }

    @Override
    public IVector1 getY() {
        return new Vector1Double(this.y_);
    }

    @Override
    public IVector1 getZ() {
        return new Vector1Double(this.z_);
    }

    public void setX(IVector1 x) {
        this.x_ = x.getAsDouble();
    }

    public void setY(IVector1 y) {
        this.y_ = y.getAsDouble();
    }

    public void setZ(IVector1 z) {
        this.z_ = z.getAsDouble();
    }

    @Override
    public int getXAsInteger() {
        return (int)this.x_;
    }

    @Override
    public int getYAsInteger() {
        return (int)this.y_;
    }

    @Override
    public int getZAsInteger() {
        return (int)this.z_;
    }

    @Override
    public long getXAsLong() {
        return (long)this.x_;
    }

    @Override
    public long getYAsLong() {
        return (long)this.y_;
    }

    @Override
    public long getZAsLong() {
        return (long)this.z_;
    }

    @Override
    public float getXAsFloat() {
        return (float)this.x_;
    }

    @Override
    public float getYAsFloat() {
        return (float)this.y_;
    }

    @Override
    public float getZAsFloat() {
        return (float)this.z_;
    }

    @Override
    public double getXAsDouble() {
        return this.x_;
    }

    @Override
    public double getYAsDouble() {
        return this.y_;
    }

    @Override
    public double getZAsDouble() {
        return this.z_;
    }

    @Override
    public BigDecimal getXAsBigDecimal() {
        return new BigDecimal(this.x_);
    }

    @Override
    public BigDecimal getYAsBigDecimal() {
        return new BigDecimal(this.y_);
    }

    @Override
    public BigDecimal getZAsBigDecimal() {
        return new BigDecimal(this.z_);
    }

    @Override
    public IVector3 copy() {
        return new Vector3Double(this.x_, this.y_, this.z_);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IVector3) {
            return this.equals((IVector3)obj);
        }
        return false;
    }

    @Override
    public boolean equals(IVector3 vector) {
        return vector != null && this.x_ == vector.getXAsDouble() && this.y_ == vector.getYAsDouble() && this.z_ == vector.getZAsDouble();
    }

    public int hashCode() {
        return (int)this.x_ * 31 + (int)this.y_ * 15 + (int)this.z_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        DecimalFormat format = new DecimalFormat("####.####");
        if (this.x_ < 1000.0 || this.x_ > 0.001) {
            buffer.append(format.format(this.x_));
        } else {
            buffer.append(Double.toString(this.x_));
        }
        buffer.append(",");
        if (this.y_ < 10000.0 || this.y_ > 0.001) {
            buffer.append(format.format(this.y_));
        } else {
            buffer.append(Double.toString(this.y_));
        }
        buffer.append(",");
        if (this.z_ < 10000.0 || this.z_ > 0.001) {
            buffer.append(format.format(this.z_));
        } else {
            buffer.append(Double.toString(this.z_));
        }
        return buffer.toString();
    }

    public static IVector3 getVector3(Double x, Double y, Double z) {
        Vector3Double ret = null;
        if (x != null && y != null && z != null) {
            ret = x == 0.0 && y == 0.0 && z == 0.0 ? ZERO : new Vector3Double(x, y, z);
        } else if (x != null || y != null || z != null) {
            ret = new Vector3Double(x == null ? 0.0 : x, y == null ? 0.0 : y, z == null ? 0.0 : z);
        }
        return ret;
    }
}

