/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics;

import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.math.Vector2Int;
import jadex.extension.envsupport.observer.graphics.IViewport;
import jadex.extension.envsupport.observer.graphics.IViewportListener;
import jadex.extension.envsupport.observer.graphics.layer.Layer;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.MouseInputAdapter;

public abstract class AbstractViewport
implements IViewport {
    protected IVector2 inversionFlag_;
    protected Canvas canvas_;
    protected Color bgColor_;
    protected IVector2 position_;
    protected IVector2 pixPosition_;
    protected float objShiftX_;
    protected float objShiftY_;
    protected boolean preserveAR_;
    protected Vector2Double size_;
    protected Vector2Double areaSize_;
    protected Vector2Double paddedSize_;
    protected Set drawObjects_;
    protected SortedSet objectLayers_;
    protected List objectList_;
    protected Layer[] preLayers_;
    protected Layer[] postLayers_;
    protected IPerspective perspective;
    protected volatile boolean rendering = false;
    private Set listeners_;
    private double zoomLimit_;

    public AbstractViewport(IPerspective perspective) {
        this.perspective = perspective;
        this.bgColor_ = Color.BLACK;
        this.inversionFlag_ = new Vector2Int(0);
        this.position_ = Vector2Double.ZERO.copy();
        this.preserveAR_ = true;
        this.size_ = new Vector2Double(1.0);
        this.areaSize_ = new Vector2Double(1.0);
        this.paddedSize_ = new Vector2Double(1.0);
        this.drawObjects_ = Collections.synchronizedSet(new HashSet());
        this.objectLayers_ = Collections.synchronizedSortedSet(new TreeSet());
        this.objectList_ = Collections.synchronizedList(new ArrayList());
        this.preLayers_ = new Layer[0];
        this.postLayers_ = new Layer[0];
        this.listeners_ = Collections.synchronizedSet(new HashSet());
        this.zoomLimit_ = 20.0;
    }

    @Override
    public void setBackground(Color bgColor) {
        this.bgColor_ = bgColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectList(List objectList) {
        List list = this.objectList_;
        synchronized (list) {
            this.objectList_.clear();
            this.objectList_.addAll(objectList);
        }
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreLayers(Layer[] layers) {
        Layer[] layerArray = this.preLayers_;
        synchronized (this.preLayers_) {
            this.preLayers_ = layers != null ? (Layer[])layers.clone() : new Layer[0];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPostLayers(Layer[] layers) {
        Layer[] layerArray = this.postLayers_;
        synchronized (this.postLayers_) {
            this.postLayers_ = layers != null ? (Layer[])layers.clone() : new Layer[0];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public IVector2 getSize() {
        return this.size_;
    }

    @Override
    public void setSize(IVector2 size) {
        Canvas canvas = this.canvas_;
        if (canvas == null) {
            return;
        }
        if (this.areaSize_.copy().divide(size).getMean().getAsDouble() > this.zoomLimit_) {
            return;
        }
        this.size_ = new Vector2Double(size);
        double width = 1.0;
        double height = 1.0;
        if (this.preserveAR_) {
            double windowAR;
            double sizeAR = size.getXAsDouble() / size.getYAsDouble();
            if (sizeAR > (windowAR = (double)canvas.getWidth() / (double)canvas.getHeight())) {
                width = size.getXAsDouble();
                double pixX = width / (double)canvas.getWidth();
                height = (double)canvas.getHeight() * pixX;
            } else {
                height = size.getYAsDouble();
                double pixY = height / (double)canvas.getHeight();
                width = (double)canvas.getWidth() * pixY;
            }
        } else {
            width = size.getXAsDouble();
            height = size.getYAsDouble();
        }
        this.paddedSize_ = new Vector2Double(width, height);
    }

    @Override
    public IVector2 getAreaSize() {
        return this.areaSize_;
    }

    @Override
    public void setAreaSize(final IVector2 areaSize) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractViewport.this.areaSize_ = new Vector2Double(areaSize);
                AbstractViewport.this.setSize(areaSize.copy());
                if (AbstractViewport.this.preserveAR_) {
                    AbstractViewport.this.setPosition(AbstractViewport.this.paddedSize_.copy().subtract(AbstractViewport.this.areaSize_).multiply(0.5).negate());
                }
            }
        });
    }

    public IVector2 getPaddedSize() {
        return this.paddedSize_;
    }

    public Rectangle getClippingBox() {
        Rectangle box = new Rectangle();
        IVector2 pixSize = this.getPixelSize();
        IVector2 boxStart = this.pixPosition_.copy().divide(pixSize).negate();
        box.x = (int)Math.round(boxStart.getXAsDouble());
        box.y = (int)Math.round(boxStart.getYAsDouble());
        IVector2 boxSize = this.areaSize_.copy().divide(pixSize);
        box.width = (int)Math.ceil(boxSize.getXAsDouble());
        box.height = (int)Math.ceil(boxSize.getYAsDouble());
        return box;
    }

    public IVector2 getPixelSize() {
        Canvas canvas = this.canvas_;
        if (canvas == null) {
            return Vector2Double.ZERO;
        }
        return this.paddedSize_.copy().divide(new Vector2Double(canvas.getWidth(), canvas.getHeight()));
    }

    public IVector2 getCanvasSize() {
        return new Vector2Double(this.canvas_.getWidth(), this.canvas_.getHeight());
    }

    @Override
    public void refreshCanvasSize() {
    }

    @Override
    public IVector2 getPosition() {
        return this.position_.copy();
    }

    @Override
    public void setPosition(IVector2 pos) {
        this.position_ = pos;
        IVector2 pixSize = this.getPixelSize();
        this.pixPosition_ = this.position_.copy().divide(pixSize);
        this.pixPosition_ = new Vector2Double(new Vector2Int(this.pixPosition_)).multiply(pixSize);
    }

    @Override
    public void setPreserveAspectRation(boolean preserveAR) {
        this.preserveAR_ = preserveAR;
        this.setSize(this.size_);
    }

    @Override
    public boolean getInvertX() {
        return this.inversionFlag_.getXAsInteger() > 0;
    }

    @Override
    public boolean getInvertY() {
        return this.inversionFlag_.getYAsInteger() > 0;
    }

    @Override
    public void setInvertX(boolean b) {
        this.inversionFlag_ = b ? new Vector2Int(1, this.inversionFlag_.getYAsInteger()) : new Vector2Int(0, this.inversionFlag_.getYAsInteger());
    }

    @Override
    public void setInvertY(boolean b) {
        this.inversionFlag_ = b ? new Vector2Int(this.inversionFlag_.getXAsInteger(), 1) : new Vector2Int(this.inversionFlag_.getXAsInteger(), 0);
    }

    public IVector2 getObjectShift() {
        return new Vector2Double(this.objShiftX_, this.objShiftY_);
    }

    @Override
    public void setObjectShift(IVector2 objectShift) {
        this.objShiftX_ = objectShift.getXAsFloat();
        this.objShiftY_ = objectShift.getYAsFloat();
    }

    @Override
    public void setZoomLimit(double zoomlimit) {
        this.zoomLimit_ = zoomlimit;
    }

    @Override
    public boolean isShowing() {
        return this.canvas_.isShowing();
    }

    @Override
    public void addViewportListener(IViewportListener listener) {
        this.listeners_.add(listener);
    }

    @Override
    public void removeViewportListener(IViewportListener listener) {
        this.listeners_.remove(listener);
    }

    @Override
    public IPerspective getPerspective() {
        return this.perspective;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLeftMouseClickEvent(IVector2 position) {
        Set set = this.listeners_;
        synchronized (set) {
            for (IViewportListener listener : this.listeners_) {
                listener.leftClicked(position.copy());
            }
        }
    }

    @Override
    public IVector2 getWorldCoordinates(int pixelX, int pixelY) {
        if (this.getInvertX()) {
            pixelX = this.canvas_.getWidth() - pixelX;
        }
        if (this.getInvertY()) {
            pixelY = this.canvas_.getHeight() - pixelY;
        }
        double xFac = this.paddedSize_.getXAsDouble() / (double)this.canvas_.getWidth();
        double yFac = this.paddedSize_.getYAsDouble() / (double)this.canvas_.getHeight();
        Vector2Double position = new Vector2Double(xFac * (double)pixelX + this.position_.getXAsDouble(), yFac * (double)(this.canvas_.getHeight() - pixelY) + this.position_.getYAsDouble());
        return position;
    }

    protected class MouseController
    extends MouseInputAdapter
    implements MouseWheelListener {
        private IVector2 lastDragPos = null;

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                IVector2 position = AbstractViewport.this.getWorldCoordinates(e.getX(), e.getY());
                AbstractViewport.this.fireLeftMouseClickEvent(position);
            } else if (e.getButton() == 3) {
                if (e.getClickCount() == 1) {
                    this.lastDragPos = new Vector2Double(e.getX(), e.getY()).multiply(AbstractViewport.this.getPixelSize());
                } else {
                    AbstractViewport.this.setAreaSize(AbstractViewport.this.areaSize_);
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            IVector2 oldMousePos = AbstractViewport.this.getWorldCoordinates(e.getX(), e.getY());
            IVector2 zoomShift = AbstractViewport.this.size_.copy().multiply(0.1 * (double)(-e.getWheelRotation()));
            IVector2 size = AbstractViewport.this.size_.copy().subtract(zoomShift);
            AbstractViewport.this.setSize(size);
            IVector2 newMousePos = AbstractViewport.this.getWorldCoordinates(e.getX(), e.getY());
            IVector2 pos = AbstractViewport.this.getPosition().copy().subtract(newMousePos.subtract(oldMousePos));
            AbstractViewport.this.setPosition(pos);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.lastDragPos != null) {
                IVector2 position = new Vector2Double(e.getX(), e.getY()).multiply(AbstractViewport.this.getPixelSize());
                IVector2 diff = position.copy().subtract(this.lastDragPos);
                if (AbstractViewport.this.getInvertX()) {
                    diff.negateX();
                }
                if (!AbstractViewport.this.getInvertY()) {
                    diff.negateY();
                }
                this.lastDragPos = position;
                AbstractViewport.this.setPosition(AbstractViewport.this.getPosition().copy().subtract(diff));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 3) {
                this.lastDragPos = null;
            }
        }
    }
}

