/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics;

import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.IVector3;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.math.Vector3Double;
import jadex.extension.envsupport.observer.graphics.IViewport3d;
import jadex.extension.envsupport.observer.graphics.IViewportListener;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import java.awt.Canvas;
import java.awt.EventQueue;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractViewport3d
implements IViewport3d {
    protected Canvas canvas_;
    protected Vector3Double size_;
    protected boolean preserveAR_;
    protected IVector3 areaSize_;
    protected Vector2Double paddedSize_;
    protected Set<Object> drawObjects_;
    protected IVector3 position_;
    protected IVector2 pixPosition_;
    protected IPerspective perspective;
    protected volatile boolean rendering = false;
    private Set<Object> listeners_;
    private double zoomLimit_;
    private boolean isGrid_ = false;

    public AbstractViewport3d(IPerspective perspective, IVector3 areasize, boolean isGrid) {
        this.perspective = perspective;
        this.size_ = new Vector3Double(1.0);
        this.position_ = Vector3Double.ZERO.copy();
        this.isGrid_ = isGrid;
        this.preserveAR_ = true;
        this.areaSize_ = areasize;
        this.paddedSize_ = new Vector2Double(1.0);
        this.drawObjects_ = new HashSet<Object>();
        this.listeners_ = new HashSet<Object>();
        this.zoomLimit_ = 20.0;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas_;
    }

    public IVector3 getSize() {
        return this.size_;
    }

    @Override
    public IVector3 getAreaSize() {
        return this.areaSize_;
    }

    public IVector3 getAreaSize3d() {
        return this.areaSize_;
    }

    @Override
    public void setAreaSize(final IVector3 areaSize) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractViewport3d.this.areaSize_ = new Vector3Double(areaSize);
            }
        });
    }

    public IVector2 getPaddedSize() {
        return this.paddedSize_;
    }

    public IVector2 getCanvasSize() {
        return new Vector2Double(this.canvas_.getWidth(), this.canvas_.getHeight());
    }

    public IVector3 getPosition() {
        return this.position_.copy();
    }

    public boolean isShowing() {
        return this.canvas_.isShowing();
    }

    public void addViewportListener(IViewportListener listener) {
        this.listeners_.add(listener);
    }

    public void removeViewportListener(IViewportListener listener) {
        this.listeners_.remove(listener);
    }

    @Override
    public IPerspective getPerspective() {
        return this.perspective;
    }

    @Override
    public void isGridSpace(boolean isGrid) {
        this.isGrid_ = isGrid;
    }
}

