/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.drawable;

import jadex.commons.IPropertyObject;
import jadex.commons.IValueFetcher;
import jadex.extension.envsupport.observer.graphics.IViewport;
import jadex.extension.envsupport.observer.graphics.drawable.AbstractVisual2D;
import jadex.extension.envsupport.observer.graphics.drawable.Primitive;
import jadex.extension.envsupport.observer.gui.SObjectInspector;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DrawableCombiner
extends AbstractVisual2D
implements IPropertyObject {
    private Map primitives = new HashMap();
    protected Map properties;

    public DrawableCombiner() {
        this(null, null, null);
    }

    public DrawableCombiner(Object position, Object rotation, Object size) {
        super(position == null ? "position" : position, rotation, size);
    }

    public void addPrimitive(Primitive p) {
        this.addPrimitive(p, 0);
    }

    public void addPrimitive(Primitive p, int layer) {
        Integer l = new Integer(layer);
        ArrayList<Primitive> drawList = (ArrayList<Primitive>)this.primitives.get(l);
        if (drawList == null) {
            drawList = new ArrayList<Primitive>();
            this.primitives.put(l, drawList);
        }
        drawList.add(p);
    }

    public void removePrimitive(Primitive p) {
        Collection drawLists = this.primitives.values();
        for (List drawList : drawLists) {
            drawList.remove(p);
        }
    }

    public void draw(Object obj, Integer layer, IViewport vp) {
        List drawList = (List)this.primitives.get(layer);
        if (drawList == null) {
            return;
        }
        for (Primitive p : drawList) {
            vp.drawPrimitive(this, p, obj);
        }
    }

    public Set getLayers() {
        HashSet layers = new HashSet(this.primitives.keySet());
        return layers;
    }

    public void flushRenderInfo() {
        for (List drawList : this.primitives.values()) {
            for (Primitive p : drawList) {
                p.flushRenderInfo();
            }
        }
    }

    public Object getBoundValue(Object obj, Object prop, IViewport viewport) {
        Object ret = prop;
        if (prop instanceof String) {
            String name = (String)prop;
            ret = this.getProperty(name);
            if (ret instanceof IParsedExpression) {
                SimpleValueFetcher fetcher = new SimpleValueFetcher((IValueFetcher)viewport.getPerspective().getObserverCenter().getSpace().getFetcher());
                fetcher.setValue("$drawable", (Object)this);
                fetcher.setValue("$object", obj);
                fetcher.setValue("$perspective", (Object)viewport.getPerspective());
                ret = ((IParsedExpression)ret).getValue((IValueFetcher)fetcher);
            }
            if (ret == null) {
                ret = SObjectInspector.getProperty(obj, name);
            }
        }
        return ret;
    }

    public Object getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public Set getPropertyNames() {
        return this.properties == null ? Collections.EMPTY_SET : this.properties.keySet();
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public boolean hasProperty(String name) {
        return this.properties != null && this.properties.containsKey(name);
    }
}

