/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.java2d;

import jadex.commons.IValueFetcher;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.IVector3;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.math.Vector3Double;
import jadex.extension.envsupport.observer.graphics.IViewport;
import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.graphics.drawable.Primitive;
import jadex.extension.envsupport.observer.graphics.java2d.IJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.ViewportJ2D;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public abstract class AbstractJ2DRenderer
implements IJ2DRenderer {
    @Override
    public final void prepareAndExecuteDraw(DrawableCombiner dc, Primitive primitive, Object obj, ViewportJ2D vp) {
        boolean draw;
        IParsedExpression drawcondition = primitive.getDrawCondition();
        boolean bl = draw = drawcondition == null;
        if (!draw) {
            SimpleValueFetcher fetcher = new SimpleValueFetcher((IValueFetcher)vp.getPerspective().getObserverCenter().getSpace().getFetcher());
            fetcher.setValue("$object", obj);
            fetcher.setValue("$perspective", (Object)vp.getPerspective());
            draw = (Boolean)drawcondition.getValue((IValueFetcher)fetcher);
        }
        if (draw) {
            Graphics2D g = vp.getContext();
            AffineTransform t = g.getTransform();
            if (!AbstractJ2DRenderer.setupDCMatrix(dc, obj, primitive.isRelativePosition(), primitive.isRelativeSize(), primitive.isRelativeRotation(), vp)) {
                return;
            }
            this.draw(dc, primitive, obj, vp);
            g.setTransform(t);
        }
    }

    public static final boolean setupDCMatrix(DrawableCombiner dc, Object obj, boolean enablePos, boolean enableSize, boolean enableRot, ViewportJ2D vp) {
        Graphics2D g = vp.getContext();
        if (enablePos) {
            IVector2 position = (IVector2)dc.getBoundValue(obj, dc.getPosition(), vp);
            if (position == null) {
                return false;
            }
            g.translate(position.getXAsDouble(), position.getYAsDouble());
        }
        if (enableSize) {
            IVector2 size = (IVector2)dc.getBoundValue(obj, dc.getSize(), vp);
            if (size == null) {
                size = new Vector2Double(1.0, 0.0);
            }
            g.scale(size.getXAsDouble(), size.getYAsDouble());
        }
        if (enableRot) {
            IVector3 rot = (IVector3)dc.getBoundValue(obj, dc.getRotation(), vp);
            if (rot == null) {
                rot = Vector3Double.ZERO.copy();
            }
            g.scale(Math.cos(rot.getYAsDouble()), Math.cos(rot.getXAsDouble()));
            g.rotate(rot.getZAsDouble());
        }
        return true;
    }

    protected boolean setupMatrix(DrawableCombiner dc, Primitive primitive, Object obj, Graphics2D g, IViewport vp) {
        IVector2 size = (IVector2)dc.getBoundValue(obj, primitive.getSize(), vp);
        IVector3 rot = (IVector3)dc.getBoundValue(obj, primitive.getRotation(), vp);
        IVector2 position = (IVector2)dc.getBoundValue(obj, primitive.getPosition(), vp);
        if (position == null || size == null || rot == null) {
            return false;
        }
        g.translate(position.getXAsDouble(), position.getYAsDouble());
        g.rotate(rot.getZAsDouble());
        g.scale(Math.cos(rot.getXAsDouble()), Math.cos(rot.getYAsDouble()));
        g.scale(size.getXAsDouble(), size.getYAsDouble());
        return true;
    }

    @Override
    public abstract void draw(DrawableCombiner var1, Primitive var2, Object var3, ViewportJ2D var4);
}

