/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.java2d;

import jadex.commons.IValueFetcher;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.graphics.drawable.Primitive;
import jadex.extension.envsupport.observer.graphics.drawable.Text;
import jadex.extension.envsupport.observer.graphics.java2d.IJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.ViewportJ2D;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;

public class TextJ2DRenderer
implements IJ2DRenderer {
    private static final FontRenderContext DUMMY_FRC = new FontRenderContext(null, true, true);

    @Override
    public void prepareAndExecuteDraw(DrawableCombiner dc, Primitive primitive, Object obj, ViewportJ2D vp) {
        boolean draw;
        IParsedExpression drawcondition = primitive.getDrawCondition();
        boolean bl = draw = drawcondition == null;
        if (!draw) {
            SimpleValueFetcher fetcher = new SimpleValueFetcher((IValueFetcher)vp.getPerspective().getObserverCenter().getSpace().getFetcher());
            fetcher.setValue("$object", obj);
            fetcher.setValue("$perspective", (Object)vp.getPerspective());
            draw = (Boolean)drawcondition.getValue((IValueFetcher)fetcher);
        }
        if (draw) {
            this.draw(dc, primitive, obj, vp);
        }
    }

    @Override
    public void draw(DrawableCombiner dc, Primitive primitive, Object obj, ViewportJ2D vp) {
        Text textP = (Text)primitive;
        IVector2 position = ((IVector2)dc.getBoundValue(obj, primitive.getPosition(), vp)).copy();
        IVector2 dcPos = Vector2Double.ZERO;
        if (primitive.isRelativePosition()) {
            dcPos = (IVector2)dc.getBoundValue(obj, dc.getPosition(), vp);
        }
        IVector2 dcScale = (IVector2)dc.getBoundValue(obj, dc.getSize(), vp);
        if (position == null || dcPos == null || dcScale == null) {
            return;
        }
        IVector2 canvasSize = vp.getCanvasSize();
        float fontscale = Text.getBasicFontScale(canvasSize, vp.getAreaSize(), vp.getSize());
        if (primitive.isRelativeSize()) {
            position.multiply(dcScale);
        }
        Font font = textP.getBaseFont().deriveFont((float)textP.getBaseFont().getSize() * fontscale);
        Graphics2D g = vp.getContext();
        IVector2 pos = Text.getBasePosition(vp, dcPos, position, canvasSize, vp.getInvertX(), !vp.getInvertY());
        double xPos = pos.getXAsDouble();
        double yPos = pos.getYAsDouble();
        String text = Text.getReplacedText(dc, obj, textP.getText(), vp);
        String[] lines = text.split("(\n\r?)|(\r)");
        AffineTransform t = g.getTransform();
        g.setTransform(vp.getDefaultTransform());
        Color color = (Color)dc.getBoundValue(obj, primitive.getColor(), vp);
        g.setColor(color);
        for (int i = 0; i < lines.length; ++i) {
            TextLayout tl = new TextLayout(lines[i], font, DUMMY_FRC);
            if (i != 0) {
                yPos += (double)tl.getAscent();
            }
            tl.draw(g, (int)(xPos + textP.getAlignment(tl)), (int)yPos);
            yPos += (double)(tl.getDescent() + tl.getLeading());
        }
        g.setTransform(t);
    }
}

