/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.java2d;

import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.observer.graphics.AbstractViewport;
import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.graphics.drawable.Primitive;
import jadex.extension.envsupport.observer.graphics.java2d.ColorLayerJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.EllipseJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.GridLayerJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.IJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.ILayerJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.RectangleJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.RegularPolygonJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.TextJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.TexturedRectangleJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.TiledLayerJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.TriangleJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.layer.Layer;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.imageio.ImageIO;

public class ViewportJ2D
extends AbstractViewport
implements ComponentListener {
    private Map imageCache_;
    private Runnable renderFrameAction_;
    private Graphics2D context_;
    private ClassLoader classloader;
    private AffineTransform defaultTransform_;
    private static final IJ2DRenderer[] RENDERERS = new IJ2DRenderer[6];
    private static final ILayerJ2DRenderer[] LAYER_RENDERERS;

    public ViewportJ2D(IPerspective persp, ClassLoader classloader) {
        super(persp);
        this.classloader = classloader;
        this.imageCache_ = Collections.synchronizedMap(new HashMap());
        this.canvas_ = new ViewportCanvas();
        this.canvas_.addComponentListener(this);
        AbstractViewport.MouseController mc = new AbstractViewport.MouseController();
        this.canvas_.addMouseListener(mc);
        this.canvas_.addMouseWheelListener(mc);
        this.canvas_.addMouseMotionListener(mc);
        this.renderFrameAction_ = new Runnable(){

            @Override
            public void run() {
                ViewportJ2D.this.rendering = false;
                ViewportJ2D.this.canvas_.repaint();
            }
        };
    }

    public BufferedImage getImage(String path) {
        BufferedImage image = (BufferedImage)this.imageCache_.get(path);
        if (image == null) {
            image = this.loadImage(path);
            this.imageCache_.put(path, image);
        }
        return image;
    }

    @Override
    public void refresh() {
        if (!this.rendering) {
            this.rendering = true;
            EventQueue.invokeLater(this.renderFrameAction_);
        }
    }

    public Graphics2D getContext() {
        return this.context_;
    }

    public AffineTransform getDefaultTransform() {
        return this.defaultTransform_;
    }

    public AffineTransform getImageTransform(int sizeX, int sizeY) {
        AffineTransform imageTransform = new AffineTransform();
        imageTransform.translate(1.0 * (double)this.inversionFlag_.getXAsInteger(), 1.0 * (double)this.inversionFlag_.getYAsInteger());
        imageTransform.scale((double)(-((this.inversionFlag_.getXAsInteger() << 1) - 1)) / (double)sizeX, (double)(-((this.inversionFlag_.getYAsInteger() << 1) - 1)) / (double)sizeY);
        return imageTransform;
    }

    @Override
    public void drawPrimitive(DrawableCombiner dc, Primitive primitive, Object obj) {
        RENDERERS[primitive.getType()].prepareAndExecuteDraw(dc, primitive, obj, this);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.canvas_.getWidth() == 0 || this.canvas_.getHeight() == 0) {
            return;
        }
        IVector2 oldPaddedSize = this.paddedSize_.copy();
        this.setSize(this.size_);
        this.setPosition(this.paddedSize_.copy().subtract(oldPaddedSize).multiply(0.5).negate().add(this.position_));
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private BufferedImage loadImage(String path) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.classloader.getResource(path));
            AffineTransform tf = AffineTransform.getScaleInstance(1.0, -1.0);
            tf.translate(0.0, -image.getHeight());
            AffineTransformOp op = new AffineTransformOp(tf, 1);
            image = op.filter(image, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    static {
        ViewportJ2D.RENDERERS[0] = new EllipseJ2DRenderer();
        ViewportJ2D.RENDERERS[1] = new RectangleJ2DRenderer();
        ViewportJ2D.RENDERERS[2] = new RegularPolygonJ2DRenderer();
        ViewportJ2D.RENDERERS[3] = new TextJ2DRenderer();
        ViewportJ2D.RENDERERS[4] = new TexturedRectangleJ2DRenderer();
        ViewportJ2D.RENDERERS[5] = new TriangleJ2DRenderer();
        LAYER_RENDERERS = new ILayerJ2DRenderer[3];
        ViewportJ2D.LAYER_RENDERERS[0] = new ColorLayerJ2DRenderer();
        ViewportJ2D.LAYER_RENDERERS[1] = new GridLayerJ2DRenderer();
        ViewportJ2D.LAYER_RENDERERS[2] = new TiledLayerJ2DRenderer();
    }

    private class ViewportCanvas
    extends Canvas {
        private BufferedImage backBuffer_ = new BufferedImage(1, 1, 7);
        private Rectangle2D.Double clearRectangle_ = new Rectangle2D.Double();

        public ViewportCanvas() {
            this.clearRectangle_.x = 0.0;
            this.clearRectangle_.y = 0.0;
            this.clearRectangle_.width = ViewportJ2D.this.size_.getXAsDouble();
            this.clearRectangle_.height = ViewportJ2D.this.size_.getYAsDouble();
        }

        @Override
        public Dimension minimumSize() {
            return new Dimension(1, 1);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(1, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics gfx) {
            try {
                Layer l;
                if (this.getWidth() == 0 || this.getHeight() == 0) {
                    return;
                }
                if (this.backBuffer_.getWidth() != this.getWidth() || this.backBuffer_.getHeight() != this.getHeight()) {
                    this.backBuffer_ = new BufferedImage(this.getWidth(), this.getHeight(), 7);
                    ViewportJ2D.this.setSize(ViewportJ2D.this.size_);
                }
                Graphics2D g = (Graphics2D)this.backBuffer_.getGraphics();
                ViewportJ2D.this.defaultTransform_ = g.getTransform();
                g.setColor(ViewportJ2D.this.bgColor_);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                Rectangle clipRect = ViewportJ2D.this.getClippingBox();
                if (ViewportJ2D.this.getInvertX()) {
                    clipRect.x = ViewportJ2D.this.canvas_.getWidth() - clipRect.x - clipRect.width;
                }
                if (!ViewportJ2D.this.getInvertY()) {
                    clipRect.y = ViewportJ2D.this.canvas_.getHeight() - clipRect.y - clipRect.height;
                }
                g.setClip(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
                this.setupTransform(g);
                ViewportJ2D.this.context_ = g;
                Object object = ViewportJ2D.this.preLayers_;
                synchronized (object) {
                    for (int i = 0; i < ViewportJ2D.this.preLayers_.length; ++i) {
                        l = ViewportJ2D.this.preLayers_[i];
                        LAYER_RENDERERS[l.getType()].draw(ViewportJ2D.this.getPerspective(), l, ViewportJ2D.this.areaSize_, ViewportJ2D.this);
                    }
                }
                object = ViewportJ2D.this.objectList_;
                synchronized (object) {
                    SortedSet i = ViewportJ2D.this.objectLayers_;
                    synchronized (i) {
                        ViewportJ2D.this.objectLayers_.clear();
                        for (Object[] o : ViewportJ2D.this.objectList_) {
                            DrawableCombiner d = (DrawableCombiner)o[1];
                            if (!ViewportJ2D.this.drawObjects_.contains(d)) {
                                ViewportJ2D.this.drawObjects_.add(d);
                            }
                            ViewportJ2D.this.objectLayers_.addAll(d.getLayers());
                        }
                        AffineTransform tf = g.getTransform();
                        g.translate(ViewportJ2D.this.objShiftX_, ViewportJ2D.this.objShiftY_);
                        Object monitor = ViewportJ2D.this.getPerspective().getObserverCenter().getSpace().getMonitor();
                        for (Integer layer : ViewportJ2D.this.objectLayers_) {
                            for (Object[] o : ViewportJ2D.this.objectList_) {
                                Object obj = o[0];
                                DrawableCombiner d = (DrawableCombiner)o[1];
                                Object object2 = monitor;
                                synchronized (object2) {
                                    d.draw(obj, layer, ViewportJ2D.this);
                                }
                            }
                        }
                        g.setTransform(tf);
                    }
                }
                object = ViewportJ2D.this.postLayers_;
                synchronized (object) {
                    for (int i = 0; i < ViewportJ2D.this.postLayers_.length; ++i) {
                        l = ViewportJ2D.this.postLayers_[i];
                        LAYER_RENDERERS[l.getType()].draw(ViewportJ2D.this.getPerspective(), l, ViewportJ2D.this.areaSize_, ViewportJ2D.this);
                    }
                }
                ViewportJ2D.this.context_ = null;
                g.setTransform(ViewportJ2D.this.defaultTransform_);
                g.dispose();
                gfx.drawImage(this.backBuffer_, 0, 0, null);
                gfx.dispose();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        private void setupTransform(Graphics2D g) {
            g.translate(this.backBuffer_.getWidth() * ViewportJ2D.this.inversionFlag_.getXAsInteger(), this.backBuffer_.getHeight() * (ViewportJ2D.this.inversionFlag_.getYAsInteger() ^ 1));
            g.scale((double)this.backBuffer_.getWidth() / ViewportJ2D.this.paddedSize_.getXAsDouble() * (double)(-((ViewportJ2D.this.inversionFlag_.getXAsInteger() << 1) - 1)), (double)this.backBuffer_.getHeight() / ViewportJ2D.this.paddedSize_.getYAsDouble() * (double)((ViewportJ2D.this.inversionFlag_.getYAsInteger() << 1) - 1));
            g.translate(-ViewportJ2D.this.pixPosition_.getXAsDouble(), -ViewportJ2D.this.pixPosition_.getYAsDouble());
        }
    }
}

