/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.layer;

import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.observer.graphics.layer.Layer;
import java.awt.Color;

public class TiledLayer
extends Layer {
    protected String texturePath_;
    private IVector2 tileSize_;
    private IVector2 invTileSize_;

    public TiledLayer() {
        this(new Vector2Double(1.0), Color.WHITE, "");
    }

    public TiledLayer(IVector2 tileSize, Object color, String texturePath) {
        super(2, color);
        this.tileSize_ = tileSize.copy();
        this.invTileSize_ = new Vector2Double(1.0).divide(this.tileSize_);
        this.texturePath_ = texturePath;
    }

    public IVector2 getTileSize() {
        return this.tileSize_;
    }

    public IVector2 getInvTileSize() {
        return this.invTileSize_;
    }

    public String getTexturePath() {
        return this.texturePath_;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TiledLayer) {
            TiledLayer other = (TiledLayer)obj;
            return this.tileSize_.equals(other.tileSize_) && this.texturePath_.equals(other.texturePath_);
        }
        return false;
    }
}

