/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.gui.plugin;

import jadex.commons.SimplePropertyObject;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.observer.graphics.IViewport;
import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.gui.ObserverCenter;
import jadex.extension.envsupport.observer.gui.plugin.IObserverCenterPlugin;
import jadex.extension.envsupport.observer.perspective.Perspective2D;
import java.awt.Canvas;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractInteractionPlugin
extends SimplePropertyObject
implements IObserverCenterPlugin {
    private DrawableCombiner marker;
    private ObserverCenter obsCenter;
    private List listeners;
    private MouseListener clickListener;
    private ChangeListener objectListener;
    private boolean initialized = false;

    public void addMouseListener(MouseListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected abstract void initialize(ObserverCenter var1);

    protected void startUp(ObserverCenter center) {
    }

    protected void cleanUp(ObserverCenter center) {
    }

    protected void handleObjectClick(ISpaceObject object) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getIconPath() {
        return "jadex/application/space/envsupport/observer/images/introspector_icon.png";
    }

    @Override
    public final void shutdown() {
        ((Perspective2D)this.obsCenter.getSelectedPerspective()).setMarkerDrawCombiner(this.marker);
        ((Canvas)((Perspective2D)this.obsCenter.getSelectedPerspective()).getView()).removeMouseListener(this.clickListener);
        this.obsCenter.removeSelectedObjectListener(this.objectListener);
        this.cleanUp(this.obsCenter);
    }

    @Override
    public final void start(ObserverCenter main) {
        if (!this.initialized) {
            this.initialize(main);
            this.obsCenter = main;
            this.clickListener = new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    e.setSource(AbstractInteractionPlugin.this);
                    if (AbstractInteractionPlugin.this.listeners != null) {
                        Iterator it = AbstractInteractionPlugin.this.listeners.iterator();
                        while (it.hasNext()) {
                            ((MouseListener)it.next()).mouseReleased(e);
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    e.setSource(AbstractInteractionPlugin.this);
                    if (AbstractInteractionPlugin.this.listeners != null) {
                        Iterator it = AbstractInteractionPlugin.this.listeners.iterator();
                        while (it.hasNext()) {
                            ((MouseListener)it.next()).mousePressed(e);
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    e.setSource(AbstractInteractionPlugin.this);
                    if (AbstractInteractionPlugin.this.listeners != null) {
                        Iterator it = AbstractInteractionPlugin.this.listeners.iterator();
                        while (it.hasNext()) {
                            ((MouseListener)it.next()).mouseExited(e);
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    e.setSource(AbstractInteractionPlugin.this);
                    if (AbstractInteractionPlugin.this.listeners != null) {
                        Iterator it = AbstractInteractionPlugin.this.listeners.iterator();
                        while (it.hasNext()) {
                            ((MouseListener)it.next()).mouseEntered(e);
                        }
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.setSource(AbstractInteractionPlugin.this);
                    if (AbstractInteractionPlugin.this.listeners != null) {
                        Iterator it = AbstractInteractionPlugin.this.listeners.iterator();
                        while (it.hasNext()) {
                            ((MouseListener)it.next()).mouseClicked(e);
                        }
                    }
                }
            };
            this.objectListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (AbstractInteractionPlugin.this.obsCenter.getSelectedPerspective().getSelectedObject() != null) {
                        AbstractInteractionPlugin.this.handleObjectClick((ISpaceObject)AbstractInteractionPlugin.this.obsCenter.getSelectedPerspective().getSelectedObject());
                    }
                }
            };
            this.initialized = true;
        }
        main.getSelectedPerspective().setSelectedObject(null);
        this.marker = ((Perspective2D)main.getSelectedPerspective()).getMarkerDrawCombiner();
        ((Perspective2D)main.getSelectedPerspective()).setMarkerDrawCombiner(new DrawableCombiner());
        ((Canvas)((Perspective2D)main.getSelectedPerspective()).getView()).addMouseListener(this.clickListener);
        main.addSelectedObjectListener(this.objectListener);
        this.startUp(main);
    }

    public IVector2 getWorldCoordinates(Point p) {
        IViewport viewport = ((Perspective2D)this.obsCenter.getSelectedPerspective()).getViewport();
        return viewport.getWorldCoordinates((int)p.getX(), (int)p.getY());
    }
}

