/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.gui.plugin;

import jadex.extension.envsupport.environment.IObjectTask;
import jadex.extension.envsupport.environment.ISpaceProcess;
import jadex.extension.envsupport.environment.SpaceObject;
import jadex.extension.envsupport.observer.gui.ObserverCenter;
import jadex.extension.envsupport.observer.gui.SObjectInspector;
import jadex.extension.envsupport.observer.gui.plugin.IObserverCenterPlugin;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class IntrospectorPlugin
implements IObserverCenterPlugin {
    private static final String NAME = "Introspector";
    private static final String[] COLUMM_NAMES = new String[]{"Property", "Value"};
    private JTabbedPane mainPane_ = new JTabbedPane();
    private JTable spacePropertyTable_;
    private JTable perspPropertyTable_;
    private JList processList_;
    private JTable processPropertyTable_;
    private JList taskList_;
    private JTable taskPropertyTable_;
    private JLabel objIdLabel_;
    private JLabel objTypeLabel_;
    private JTable objPropertyTable_;
    private ObserverCenter observerCenter_;
    private ChangeListener selectionListener;

    public IntrospectorPlugin() {
        this.mainPane_.setMinimumSize(new Dimension(50, 400));
        JSplitPane spacePane = new JSplitPane();
        spacePane.setOrientation(0);
        spacePane.setOneTouchExpandable(true);
        spacePane.setDividerLocation(100);
        spacePane.setResizeWeight(0.33);
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 10;
        c.fill = 1;
        this.mainPane_.add("Space", spacePane);
        JPanel spacePropertyPanel = new JPanel();
        spacePropertyPanel.setLayout(new GridBagLayout());
        spacePane.setTopComponent(spacePropertyPanel);
        this.spacePropertyTable_ = new JTable(new DefaultTableModel(new Object[0][2], COLUMM_NAMES));
        JScrollPane spcPropScrollPane = new JScrollPane(this.spacePropertyTable_);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.fill = 1;
        spacePropertyPanel.add((Component)spcPropScrollPane, c);
        TableColumn col = this.spacePropertyTable_.getColumnModel().getColumn(0);
        col.setPreferredWidth(80);
        col.setMaxWidth(300);
        JPanel processPanel = new JPanel();
        processPanel.setBorder(new TitledBorder("Processes"));
        processPanel.setLayout(new GridBagLayout());
        spacePane.setBottomComponent(processPanel);
        JSplitPane processPane = new JSplitPane();
        processPane.setOrientation(0);
        processPane.setOneTouchExpandable(true);
        processPane.setDividerLocation(60);
        processPane.setResizeWeight(0.5);
        c = new GridBagConstraints();
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 10;
        c.fill = 1;
        processPanel.add((Component)processPane, c);
        this.processList_ = new JList(new DefaultComboBoxModel());
        this.processList_.setSelectionMode(0);
        this.processList_.setBorder(new BevelBorder(1));
        processPane.setTopComponent(this.processList_);
        this.processPropertyTable_ = new JTable(new DefaultTableModel(new Object[0][2], COLUMM_NAMES));
        JScrollPane procPropScrollPane = new JScrollPane(this.processPropertyTable_);
        processPane.setBottomComponent(procPropScrollPane);
        col = this.processPropertyTable_.getColumnModel().getColumn(0);
        col.setPreferredWidth(80);
        col.setMaxWidth(300);
        final JSplitPane objectPane = new JSplitPane();
        objectPane.setOrientation(0);
        objectPane.setOneTouchExpandable(true);
        objectPane.setDividerLocation(100);
        objectPane.setResizeWeight(0.33);
        this.mainPane_.add("Object", objectPane);
        JPanel perspPropertyPane = new JPanel(new BorderLayout());
        this.mainPane_.add("Perspective", perspPropertyPane);
        this.perspPropertyTable_ = new JTable(new DefaultTableModel(new Object[0][2], COLUMM_NAMES));
        JScrollPane sp = new JScrollPane(this.perspPropertyTable_);
        perspPropertyPane.add((Component)sp, "Center");
        col = this.perspPropertyTable_.getColumnModel().getColumn(0);
        col.setPreferredWidth(80);
        col.setMaxWidth(300);
        JPanel objectPropertyPanel = new JPanel();
        objectPropertyPanel.setLayout(new GridBagLayout());
        objectPane.setTopComponent(objectPropertyPanel);
        JLabel idLabelDesc = new JLabel("Object ID");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.ipadx = 10;
        c.anchor = 18;
        c.fill = 0;
        objectPropertyPanel.add((Component)idLabelDesc, c);
        this.objIdLabel_ = new JLabel("");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.fill = 0;
        objectPropertyPanel.add((Component)this.objIdLabel_, c);
        JLabel typeLabelDesc = new JLabel("Type");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.ipadx = 10;
        c.anchor = 18;
        c.fill = 0;
        objectPropertyPanel.add((Component)typeLabelDesc, c);
        this.objTypeLabel_ = new JLabel("");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.fill = 0;
        objectPropertyPanel.add((Component)this.objTypeLabel_, c);
        this.objPropertyTable_ = new JTable(new DefaultTableModel(new Object[0][2], COLUMM_NAMES));
        JScrollPane tableScrollPane = new JScrollPane(this.objPropertyTable_);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.fill = 1;
        objectPropertyPanel.add((Component)tableScrollPane, c);
        col = this.objPropertyTable_.getColumnModel().getColumn(0);
        col.setPreferredWidth(80);
        col.setMaxWidth(300);
        JPanel taskPanell = new JPanel();
        taskPanell.setBorder(new TitledBorder("Tasks"));
        taskPanell.setLayout(new GridBagLayout());
        objectPane.setBottomComponent(taskPanell);
        JSplitPane taskPane = new JSplitPane();
        taskPane.setOrientation(0);
        taskPane.setOneTouchExpandable(true);
        taskPane.setDividerLocation(60);
        taskPane.setResizeWeight(0.5);
        c = new GridBagConstraints();
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 10;
        c.fill = 1;
        taskPanell.add((Component)taskPane, c);
        this.taskList_ = new JList(new DefaultComboBoxModel());
        this.taskList_.setSelectionMode(0);
        this.taskList_.setBorder(new BevelBorder(1));
        taskPane.setTopComponent(this.taskList_);
        this.taskPropertyTable_ = new JTable(new DefaultTableModel(new Object[0][2], COLUMM_NAMES));
        JScrollPane taskPropScrollPane = new JScrollPane(this.taskPropertyTable_);
        taskPane.setBottomComponent(taskPropScrollPane);
        col = this.taskPropertyTable_.getColumnModel().getColumn(0);
        col.setPreferredWidth(80);
        col.setMaxWidth(300);
        this.selectionListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object selection = IntrospectorPlugin.this.observerCenter_.getSelectedPerspective().getSelectedObject();
                if (selection != null) {
                    IntrospectorPlugin.this.mainPane_.setSelectedComponent(objectPane);
                }
            }
        };
    }

    @Override
    public synchronized void start(ObserverCenter main) {
        this.observerCenter_ = main;
        this.observerCenter_.addSelectedObjectListener(this.selectionListener);
    }

    @Override
    public synchronized void shutdown() {
        this.observerCenter_.removeSelectedObjectListener(this.selectionListener);
    }

    @Override
    public synchronized String getName() {
        return NAME;
    }

    @Override
    public String getIconPath() {
        return this.getClass().getPackage().getName().replaceAll("gui\\.plugin", "").concat("images.").replaceAll("\\.", "/").concat("introspector_icon.png");
    }

    @Override
    public synchronized Component getView() {
        return this.mainPane_;
    }

    @Override
    public synchronized void refresh() {
        IntrospectorPlugin.fillPropertyTable(this.spacePropertyTable_, this.observerCenter_.getSpace());
        DefaultComboBoxModel plModel = (DefaultComboBoxModel)this.processList_.getModel();
        Object selection = this.processList_.getSelectedValue();
        plModel.removeAllElements();
        Set processIds = this.observerCenter_.getSpace().getSpaceProcessNames();
        for (Object id : processIds) {
            ISpaceProcess proc = this.observerCenter_.getSpace().getSpaceProcess(id);
            if (proc == null) continue;
            plModel.addElement(proc);
        }
        this.processList_.setSelectedValue(selection, true);
        if (selection != null) {
            IntrospectorPlugin.fillPropertyTable(this.processPropertyTable_, selection);
        } else {
            ((DefaultTableModel)this.processPropertyTable_.getModel()).setRowCount(0);
        }
        IPerspective p = this.observerCenter_.getSelectedPerspective();
        Object observedObj = p.getSelectedObject();
        if (observedObj == null) {
            this.objIdLabel_.setText("");
            this.objTypeLabel_.setText("");
            this.objPropertyTable_.setModel(new DefaultTableModel(new Object[0][2], COLUMM_NAMES));
            TableColumn col = this.objPropertyTable_.getColumnModel().getColumn(0);
            col.setPreferredWidth(80);
            col.setMaxWidth(300);
        } else if (!IntrospectorPlugin.fillPropertyTable(this.objPropertyTable_, observedObj)) {
            p.setSelectedObject(null);
        } else {
            this.objIdLabel_.setText(String.valueOf(SObjectInspector.getId(observedObj)));
            String type = String.valueOf(SObjectInspector.getType(observedObj));
            this.objTypeLabel_.setText(type);
            if (observedObj instanceof SpaceObject) {
                DefaultComboBoxModel tlModel = (DefaultComboBoxModel)this.taskList_.getModel();
                SpaceObject sObj = (SpaceObject)observedObj;
                Collection tasks = sObj.getTasks();
                selection = this.taskList_.getSelectedValue();
                tlModel.removeAllElements();
                for (IObjectTask task : tasks) {
                    tlModel.addElement(task);
                }
                if (tasks.contains(selection)) {
                    this.taskList_.setSelectedValue(selection, true);
                }
            }
            if (selection != null) {
                IntrospectorPlugin.fillPropertyTable(this.taskPropertyTable_, selection);
            } else {
                ((DefaultTableModel)this.taskPropertyTable_.getModel()).setRowCount(0);
            }
        }
        IntrospectorPlugin.fillPropertyTable(this.perspPropertyTable_, this.observerCenter_.getSelectedPerspective());
    }

    private static boolean fillPropertyTable(JTable table, Object propHolder) {
        Set propNames = SObjectInspector.getPropertyNames(propHolder);
        if (propNames != null) {
            Object[][] dataSet = new Object[propNames.size()][2];
            int i = 0;
            for (String name : propNames) {
                dataSet[i][0] = name;
                dataSet[i][1] = String.valueOf(SObjectInspector.getProperty(propHolder, name));
                ++i;
            }
            DefaultTableModel model = (DefaultTableModel)table.getModel();
            model.setRowCount(dataSet.length);
            for (i = 0; i < dataSet.length; ++i) {
                model.setValueAt(dataSet[i][0], i, 0);
                model.setValueAt(dataSet[i][1], i, 1);
            }
        }
        return propNames != null;
    }
}

