/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.perspective;

import jadex.commons.IValueFetcher;
import jadex.commons.meta.TypedPropertyObject;
import jadex.extension.envsupport.dataview.IDataView;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.SpaceObject;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.environment.space3d.Space3D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.IVector3;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector3Double;
import jadex.extension.envsupport.observer.graphics.IViewport3d;
import jadex.extension.envsupport.observer.graphics.drawable3d.DrawableCombiner3d;
import jadex.extension.envsupport.observer.graphics.drawable3d.Primitive3d;
import jadex.extension.envsupport.observer.graphics.layer.Layer;
import jadex.extension.envsupport.observer.gui.ObserverCenter;
import jadex.extension.envsupport.observer.gui.SObjectInspector;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class Perspective3D
extends TypedPropertyObject
implements IPerspective {
    protected String name;
    protected ObserverCenter obscenter;
    protected IViewport3d viewport3d;
    protected Object selectedobject;
    protected int selectCycle;
    protected IVector1 selectorDistance;
    protected boolean invertxaxis;
    protected boolean invertyaxis;
    protected boolean tryopengl;
    protected Color bgColor;
    protected Map<Object, Object> visuals;
    protected Collection<DrawableCombiner3d> staticvisuals = Collections.synchronizedCollection(new ArrayList());
    protected DrawableCombiner3d marker;
    protected DrawableCombiner3d marker3d;
    protected SimpleValueFetcher fetcher;
    private Primitive3d _markerPrimitive;
    boolean wireframe;
    boolean firsttime = true;

    public Perspective3D() {
        super(null);
        System.out.println("Perspective3D --->>> new Perspective3D");
        this.visuals = Collections.synchronizedMap(new HashMap());
        this.selectorDistance = new Vector1Double(1.0);
        this.selectCycle = 0;
        this.tryopengl = true;
        this.name = this.getClass().getName();
        this.viewport3d = null;
        this._markerPrimitive = new Primitive3d(0, Vector3Double.getVector3(0.0, 0.0, 0.0), Vector3Double.getVector3(0.0, 0.0, 0.0), Vector3Double.getVector3(1.25, 1.25, 1.25), new Color(0.0f, 0.0f, 1.0f, 0.1f));
    }

    public Object getProperty(String name) {
        Object ret = super.getProperty(name);
        if (ret instanceof IParsedExpression) {
            ret = ((IParsedExpression)ret).getValue((IValueFetcher)this.getFetcher());
        }
        return ret;
    }

    public SimpleValueFetcher getFetcher() {
        if (this.fetcher == null) {
            this.fetcher = new SimpleValueFetcher((IValueFetcher)this.obscenter.getSpace().getFetcher());
            this.fetcher.setValue("$perspective", (Object)this);
        }
        return this.fetcher;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getSelectedObject() {
        return this.selectedobject;
    }

    @Override
    public void setSelectedObject(Object obj) {
        this.selectedobject = obj;
        this.obscenter.fireSelectedObjectChange();
    }

    @Override
    public void setObserverCenter(ObserverCenter obscenter) {
        this.obscenter = obscenter;
    }

    @Override
    public ObserverCenter getObserverCenter() {
        return this.obscenter;
    }

    @Override
    public void addVisual(Object id, Object visual) {
        this.visuals.put(id, visual);
    }

    @Override
    public void removeVisual(Object id) {
        this.visuals.remove(id);
    }

    @Override
    public Component getView() {
        if (this.viewport3d == null) {
            if (this.marker == null) {
                this.marker = new DrawableCombiner3d();
                this.marker.addPrimitive(this._markerPrimitive);
            }
            ClassLoader cl = this.obscenter.getClassLoader();
            boolean isGrid = this.obscenter.getSpace().getClass().getSimpleName().startsWith("Grid");
            AbstractEnvironmentSpace space = this.obscenter.getSpace();
            if (space instanceof Space2D) {
                IVector2 tmpsize = ((Space2D)space).getAreaSize();
                Vector3Double tmp3dsize = new Vector3Double(tmpsize.getXAsDouble(), (tmpsize.getXAsDouble() + tmpsize.getYAsDouble()) / 2.0, tmpsize.getYAsDouble());
                this.viewport3d = this.createViewport(this, cl, tmp3dsize, isGrid);
            } else if (space instanceof Space3D) {
                IVector3 tmp3dsize = ((Space3D)space).getAreaSize();
                this.viewport3d = this.createViewport(this, cl, tmp3dsize, isGrid);
            }
        }
        return this.viewport3d.getCanvas();
    }

    public IViewport3d getViewport() {
        if (this.viewport3d == null) {
            this.getView();
        }
        return this.viewport3d;
    }

    public boolean getInvertXAxis() {
        return this.invertxaxis;
    }

    public void setInvertXAxis(boolean invert) {
        this.invertxaxis = invert;
    }

    public boolean getInvertYAxis() {
        return this.invertyaxis;
    }

    public void setInvertYAxis(boolean invert) {
        this.invertyaxis = invert;
    }

    @Override
    public void reset() {
        System.out.println("reset!?");
    }

    @Override
    public void refresh() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.viewport3d != null) {
            IDataView dataview = this.obscenter.getSelectedDataView();
            if (dataview == null) {
                return;
            }
            Object[] objects = dataview.getObjects();
            if (this.firsttime) {
                Collection<Object> tmp = Collections.synchronizedList(new ArrayList());
                tmp = this.visuals.values();
                for (Object ob : tmp) {
                    DrawableCombiner3d combi;
                    if (!(ob instanceof DrawableCombiner3d) || (combi = (DrawableCombiner3d)ob).hasSpaceobject()) continue;
                    this.staticvisuals.add(combi);
                }
            }
            this.firsttime = false;
            ArrayList<Object[]> objectList = null;
            objectList = new ArrayList<Object[]>(objects.length + 1);
            for (int j = 0; j < objects.length; ++j) {
                Object obj = objects[j];
                DrawableCombiner3d d = (DrawableCombiner3d)this.visuals.get(SObjectInspector.getType(obj));
                if (d == null) continue;
                Object[] viewObj = new Object[]{obj, d};
                objectList.add(viewObj);
            }
            if (this.selectedobject != null) {
                int selected = ((Long)((SpaceObject)this.selectedobject).getId()).intValue();
                DrawableCombiner3d dc = (DrawableCombiner3d)this.visuals.get(SObjectInspector.getType(this.selectedobject));
                IVector3 size = (IVector3)dc.getBoundValue(this.selectedobject, dc.getSize(), this.viewport3d);
                this.marker.setSize(size);
                this.viewport3d.setSelected(selected, this.marker);
            } else {
                this.viewport3d.setSelected(-1, this.marker);
            }
            this.viewport3d.refresh(objectList, this.staticvisuals);
        }
    }

    private IViewport3d createViewport(IPerspective persp, ClassLoader cl, IVector3 spacesize, boolean isGrid) {
        System.out.println("Perspective3D - > Create new Viewport!");
        try {
            IViewport3d vp;
            Constructor<?> con = Class.forName("jadex.extension.envsupport.observer.graphics.jmonkey.ViewportJMonkey", true, Thread.currentThread().getContextClassLoader()).getConstructor(IPerspective.class, ClassLoader.class, IVector3.class, Boolean.TYPE);
            this.viewport3d = vp = (IViewport3d)con.newInstance(persp, cl, spacesize, isGrid);
            vp.startApp();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Cannot create 3D viewport. 3D add-on not installed?", cnfe);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.viewport3d;
    }

    @Override
    public boolean getOpenGl() {
        return false;
    }

    @Override
    public boolean setOpenGl(boolean opengl) {
        return false;
    }

    public void setPostlayers(Layer[] array) {
    }

    public void setPrelayers(Layer[] array) {
    }

    public void leftClicked(String identification) {
        if (identification != null && !identification.equals("-1")) {
            int id = Integer.valueOf(identification);
            Object[] objects = this.obscenter.getSelectedDataView().getObjects();
            for (int j = 0; j < objects.length; ++j) {
                Object obj = objects[j];
                Object identifier = SObjectInspector.getId(obj);
                int sobjid = Integer.valueOf(identifier.toString());
                if (sobjid != id) continue;
                this.setSelectedObject(obj);
            }
        } else {
            this.setSelectedObject(null);
        }
    }

    @Override
    public void resetZoomAndPosition() {
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public void setWireframe(boolean wireframe) {
        this.wireframe = wireframe;
    }
}

