package jadex.base.contentcodecs;

import jadex.bridge.IContentCodec;
import jadex.commons.SReflect;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;

//import nuggets.Nuggets;

/**
 *  The XML codec based on the nuggets framework.
 */
public class NuggetsXMLContentCodec implements IContentCodec, Serializable
{
	//-------- constants --------
	
	/** The language identifier. */
	public static final String	NUGGETS_XML	= "nuggets-xml";
	
	/** ObjectToXML method. */
	protected static Method otx;
	
	/** ObjectFromXML method. */
	protected static Method ofx;

	/**
	 *  Init the static methods.
	 */
	public static void init(ClassLoader classloader)
	{
		try
		{
			Class nug = SReflect.findClass("nuggets.Nuggets", null, classloader);
			otx = nug.getMethod("objectToXML", new Class[]{Object.class, ClassLoader.class});
			ofx = nug.getMethod("objectFromXML", new Class[]{String.class, ClassLoader.class});
		}
		catch(Exception e)
		{
			throw new RuntimeException("Nuggets not in classpath.", e);
		}
	}
	
	/**
	 *  Test if the codec can be used with the provided meta information.
	 *  @param props The meta information.
	 *  @return True, if it can be used.
	 */
	public boolean match(Properties props)
	{
		return NUGGETS_XML.equals(props.getProperty("language"));	// Hack!!! avoid dependency to fipa
	}

	/**
	 *  Encode data with the codec.
	 *  @param val The value.
	 *  @return The encoded object.
	 */
	public String encode(Object val, ClassLoader classloader)
	{
		if(otx==null)
			init(classloader);

		try
		{
			return ((String)otx.invoke(null, new Object[]{val, classloader}));
		}
		catch(Exception e)
		{
			throw new RuntimeException("Encoding error: "+e);
		}
	}

	/**
	 *  Decode data with the codec.
	 *  @param val The string value.
	 *  @return The encoded object.
	 */
	public Object decode(String val, ClassLoader classloader)
	{
		if(otx==null)
			init(classloader);

		try
		{
			return ofx.invoke(null, new Object[]{val, classloader});
		}
		catch(Exception e)
		{
			throw new RuntimeException("Decoding error: "+e);
		}
	}
}


//public class NuggetsXMLContentCodec implements IContentCodec, Serializable
//{
//	//-------- constants --------
//	
//	/** The language identifier. */
//	public static final String	NUGGETS_XML	= "nuggets-xml";
//	
//	/** The nuggets codec. */
//	protected static Nuggets nuggets;
//
//	/**
//	 *  Test if the codec can be used with the provided meta information.
//	 *  @param props The meta information.
//	 *  @return True, if it can be used.
//	 */
//	public boolean match(Properties props)
//	{
//		return NUGGETS_XML.equals(props.getProperty("language"));	// Hack!!! avoid dependency to fipa
//	}
//
//	/**
//	 *  Encode data with the codec.
//	 *  @param val The value.
//	 *  @return The encoded object.
//	 */
//	public String encode(Object val, ClassLoader classloader)
//	{
//		if(nuggets == null)
//			nuggets = new Nuggets();
//
//		// Hack!!! context classloader is sometimes null. argl 
////		Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
////		System.err.println("encoding with class loader: "+Thread.currentThread()+", "+Thread.currentThread().getContextClassLoader());
//
//		return nuggets.toXML(val, classloader);
//	}
//
//	/**
//	 *  Decode data with the codec.
//	 *  @param val The string value.
//	 *  @return The encoded object.
//	 */
//	public Object decode(String val, ClassLoader classloader)
//	{
//		if(nuggets == null)
//			nuggets = new Nuggets();
//
//		// Hack!!! context classloader is sometimes null. argl 
////		Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
////		System.err.println("decoding with class loader: "+Thread.currentThread()+", "+Thread.currentThread().getContextClassLoader());
//
//		return nuggets.fromXML(val, classloader);
//	}
//}
