/*
 * Decompiled with CFR 0.152.
 */
package jadex.base;

import jadex.base.service.cms.ComponentManagementService;
import jadex.bridge.CheckedAction;
import jadex.bridge.ComponentTerminatedException;
import jadex.bridge.DefaultMessageAdapter;
import jadex.bridge.IComponentAdapter;
import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentInstance;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IMessageAdapter;
import jadex.bridge.IModelInfo;
import jadex.bridge.MessageType;
import jadex.commons.Future;
import jadex.commons.ICommand;
import jadex.commons.IFuture;
import jadex.commons.concurrent.DefaultResultListener;
import jadex.commons.concurrent.DelegationResultListener;
import jadex.commons.concurrent.IExecutable;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.service.IServiceContainer;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public abstract class AbstractComponentAdapter
implements IComponentAdapter,
IExecutable,
Serializable {
    protected IComponentIdentifier cid;
    protected IExternalAccess parent;
    protected IComponentInstance component;
    protected IModelInfo model;
    protected IComponentDescription desc;
    protected Logger logger;
    protected boolean fatalerror;
    protected boolean dostep;
    protected Future stepfuture;
    protected Set breakpoints;
    protected ICommand[] breakpointcommands;
    protected transient Thread componentthread;
    protected List ext_entries;
    protected boolean ext_forbidden;
    protected boolean wokenup;
    protected boolean again;
    protected IComponentManagementService cms;

    public AbstractComponentAdapter(IComponentDescription desc, IModelInfo model, IComponentInstance component, IExternalAccess parent) {
        this.desc = desc;
        this.cid = desc.getName();
        this.model = model;
        this.component = component;
        this.parent = parent;
        this.ext_entries = Collections.synchronizedList(new ArrayList());
    }

    public void wakeup() {
        this.wokenup = true;
        if ("terminated".equals(this.desc.getState())) {
            throw new ComponentTerminatedException(this.cid.getName());
        }
        if ("idle".equals(this.desc.getProcessingState())) {
            this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object source, Object result) {
                    ((ComponentManagementService)((Object)result)).setProcessingState(AbstractComponentAdapter.this.cid, "ready");
                }
            });
        }
        if ("active".equals(this.desc.getState()) || "suspended".equals(this.desc.getState())) {
            this.doWakeup();
        }
    }

    public IComponentIdentifier getComponentIdentifier() {
        return this.cid;
    }

    public Logger getLogger() {
        String name = this.getComponentIdentifier().getLocalName();
        this.logger = LogManager.getLogManager().getLogger(name);
        if (this.logger == null) {
            try {
                this.logger = Logger.getLogger(name);
                this.initLogger(this.logger);
            }
            catch (SecurityException e) {
                this.logger = Logger.getAnonymousLogger();
                this.initLogger(this.logger);
            }
        }
        return this.logger;
    }

    protected void initLogger(Logger logger) {
        String logfile;
        Object prop = this.model.getProperties().get("logging.level");
        Level level = prop == null ? Level.WARNING : (Level)prop;
        logger.setLevel(level);
        prop = this.model.getProperties().get("logging.useParentHandlers");
        if (prop != null) {
            logger.setUseParentHandlers((Boolean)prop);
        }
        if ((prop = this.model.getProperties().get("addConsoleHandler")) != null) {
            ConsoleHandler console = new ConsoleHandler();
            console.setLevel(Level.parse(prop.toString()));
            logger.addHandler(console);
        }
        if ((logfile = (String)this.model.getProperties().get("logging.file")) != null) {
            try {
                FileHandler fh = new FileHandler(logfile);
                fh.setFormatter(new SimpleFormatter());
                logger.addHandler(fh);
            }
            catch (IOException e) {
                System.err.println("I/O Error attempting to create logfile: " + logfile + "\n" + e.getMessage());
            }
        }
    }

    public IModelInfo getModel() {
        return this.model;
    }

    public IExternalAccess getParent() {
        return this.parent;
    }

    public IFuture getChildren() {
        final Future ret = new Future();
        this.getCMS().addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                cms.getChildren(AbstractComponentAdapter.this.getComponentIdentifier()).addResultListener((IResultListener)new DelegationResultListener(ret));
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public String toString() {
        return "StandaloneComponentAdapter(" + this.cid.getName() + ")";
    }

    public IServiceContainer getServiceContainer() {
        return this.component.getServiceContainer();
    }

    protected IFuture getCMS() {
        return SServiceProvider.getServiceUpwards((IServiceProvider)this.getServiceContainer(), (Class)IComponentManagementService.class);
    }

    public IComponentDescription getDescription() {
        return this.desc;
    }

    public IFuture killComponent() {
        final Future ret = new Future();
        if ("terminated".equals(this.desc.getState())) {
            ret.setException((Exception)new ComponentTerminatedException(this.cid.getName()));
        } else if (!this.fatalerror) {
            this.component.cleanupComponent().addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    AbstractComponentAdapter.this.shutdownContainer().addResultListener((IResultListener)new DelegationResultListener(ret));
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    AbstractComponentAdapter.this.getLogger().warning("Exception during component cleanup: " + exception);
                    AbstractComponentAdapter.this.shutdownContainer().addResultListener((IResultListener)new DelegationResultListener(ret));
                }
            });
        } else {
            ret.setResult((Object)this.getComponentIdentifier());
        }
        return ret;
    }

    protected IFuture shutdownContainer() {
        final Future ret = new Future();
        this.getServiceContainer().shutdown().addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                ret.setResult((Object)AbstractComponentAdapter.this.getComponentIdentifier());
            }

            public void exceptionOccurred(Object source, Exception exception) {
                AbstractComponentAdapter.this.getLogger().warning("Exception during service container shutdown: " + exception);
                ret.setResult((Object)AbstractComponentAdapter.this.getComponentIdentifier());
            }
        });
        return ret;
    }

    public void receiveMessage(Map message, MessageType type) {
        if ("terminated".equals(this.desc.getState()) || this.fatalerror) {
            throw new ComponentTerminatedException(this.cid.getName());
        }
        DefaultMessageAdapter msg = new DefaultMessageAdapter(message, type);
        this.component.messageArrived((IMessageAdapter)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        this.wokenup = false;
        if ("terminated".equals(this.desc.getState())) {
            return false;
        }
        if (this.fatalerror) {
            throw new ComponentTerminatedException(this.cid.getName());
        }
        this.componentthread = Thread.currentThread();
        ClassLoader cl = this.componentthread.getContextClassLoader();
        this.componentthread.setContextClassLoader(this.model.getClassLoader());
        this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object source, Object result) {
                if (result != null) {
                    ((ComponentManagementService)((Object)result)).setProcessingState(AbstractComponentAdapter.this.cid, "running");
                }
            }
        });
        boolean extexecuted = false;
        Runnable[] entries = null;
        List list = this.ext_entries;
        synchronized (list) {
            if (!this.ext_entries.isEmpty()) {
                entries = this.ext_entries.toArray(new Runnable[this.ext_entries.size()]);
                this.ext_entries.clear();
                extexecuted = true;
            }
        }
        for (int i = 0; entries != null && i < entries.length; ++i) {
            if (entries[i] instanceof CheckedAction) {
                if (((CheckedAction)entries[i]).isValid()) {
                    try {
                        entries[i].run();
                    }
                    catch (Exception e) {
                        this.fatalError(e);
                    }
                }
                try {
                    ((CheckedAction)entries[i]).cleanup();
                }
                catch (Exception e) {
                    this.fatalError(e);
                }
                continue;
            }
            try {
                entries[i].run();
                continue;
            }
            catch (Exception e) {
                this.fatalError(e);
            }
        }
        boolean breakpoint_triggered = false;
        if (!this.dostep && !"suspended".equals(this.desc.getState()) && this.component.isAtBreakpoint(this.desc.getBreakpoints())) {
            breakpoint_triggered = true;
            this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object source, Object result) {
                    ((IComponentManagementService)result).suspendComponent(AbstractComponentAdapter.this.cid);
                }
            });
        }
        if (!(breakpoint_triggered || extexecuted || "suspended".equals(this.desc.getState()) && !this.dostep)) {
            try {
                this.again = this.component.executeStep();
            }
            catch (Exception e) {
                this.fatalError(e);
            }
            if (this.dostep) {
                this.dostep = false;
                if (this.stepfuture != null) {
                    this.stepfuture.setResult((Object)this.desc);
                }
            }
            if (!"suspended".equals(this.desc.getState()) && this.component.isAtBreakpoint(this.desc.getBreakpoints())) {
                breakpoint_triggered = true;
                this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        ((IComponentManagementService)result).suspendComponent(AbstractComponentAdapter.this.cid);
                    }
                });
            }
        }
        final boolean ready = this.again && !breakpoint_triggered || extexecuted || this.wokenup;
        this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object source, Object result) {
                ((ComponentManagementService)((Object)result)).setProcessingState(AbstractComponentAdapter.this.cid, ready ? "ready" : "idle");
            }
        });
        this.componentthread.setContextClassLoader(cl);
        this.componentthread = null;
        return this.again && !"suspended".equals(this.desc.getState()) || extexecuted;
    }

    protected void fatalError(final Exception e) {
        this.fatalerror = true;
        this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object source, Object result) {
                ComponentManagementService cms = (ComponentManagementService)((Object)result);
                cms.setComponentException(AbstractComponentAdapter.this.cid, e);
                cms.destroyComponent(AbstractComponentAdapter.this.cid);
            }
        });
    }

    public boolean isExternalThread() {
        return Thread.currentThread() != this.componentthread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable action) {
        if ("terminated".equals(this.desc.getState()) || this.fatalerror) {
            throw new ComponentTerminatedException(this.cid.getName());
        }
        List list = this.ext_entries;
        synchronized (list) {
            if (this.ext_forbidden) {
                throw new ComponentTerminatedException("External actions cannot be accepted due to terminated component state: " + this);
            }
            this.ext_entries.add(action);
        }
        this.wakeup();
    }

    public IComponentInstance getComponentInstance() {
        return this.component;
    }

    public IFuture doStep() {
        Future ret = new Future();
        if ("terminated".equals(this.desc.getState()) || this.fatalerror) {
            ret.setException((Exception)new ComponentTerminatedException(this.cid.getName()));
        } else if (this.dostep) {
            ret.setException((Exception)new RuntimeException("Only one step allowed at a time."));
        }
        this.dostep = true;
        this.stepfuture = ret;
        this.wakeup();
        return ret;
    }

    protected abstract void doWakeup();
}

