/*
 * Decompiled with CFR 0.152.
 */
package jadex.base;

import jadex.base.fipa.CMSComponentDescription;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IArgument;
import jadex.bridge.IComponentAdapter;
import jadex.bridge.IComponentAdapterFactory;
import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentFactory;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentInstance;
import jadex.bridge.IModelInfo;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.concurrent.IResultListener;
import jadex.javaparser.SJavaParser;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Starter {
    public static final String FALLBACK_PLATFORM_CONFIGURATION = "jadex/standalone/Platform.application.xml";
    public static final String FALLBACK_COMPONENT_FACTORY = "jadex.application.ApplicationComponentFactory";
    public static final String FALLBACK_ADAPTER_FACTORY = "jadex.standalone.ComponentAdapterFactory";
    public static final String CONFIGURATION_FILE = "conf";
    public static final String CONFIGURATION_NAME = "configname";
    public static final String PLATFORM_NAME = "platformname";
    public static final String COMPONENT_FACTORY = "componentfactory";
    public static final String ADAPTER_FACTORY = "adapterfactory";
    public static final Set RESERVED = new HashSet();

    public static void main(String[] args) {
        Starter.createPlatform(args);
    }

    public static IFuture createPlatform(String[] args) {
        try {
            final long starttime = System.currentTimeMillis();
            HashMap<String, String> cmdargs = new HashMap<String, String>();
            HashMap<String, Object> compargs = new HashMap<String, Object>();
            for (int i = 0; i < args.length; i += 2) {
                String key = args[i].substring(1);
                Object val = args[i + 1];
                if (!RESERVED.contains(key)) {
                    try {
                        val = SJavaParser.evaluateExpression((String)args[i + 1], null);
                        compargs.put(key, val);
                    }
                    catch (Exception e) {
                        System.out.println("Argument parse exception using as string: " + args[i] + "=" + args[i + 1]);
                    }
                }
                cmdargs.put(key, (String)val);
            }
            ClassLoader cl = Starter.class.getClassLoader();
            String configfile = (String)cmdargs.get(CONFIGURATION_FILE) != null ? (String)cmdargs.get(CONFIGURATION_FILE) : FALLBACK_PLATFORM_CONFIGURATION;
            String cfclname = (String)cmdargs.get(COMPONENT_FACTORY) != null ? (String)cmdargs.get(COMPONENT_FACTORY) : FALLBACK_COMPONENT_FACTORY;
            Class cfclass = SReflect.findClass((String)cfclname, null, (ClassLoader)cl);
            IComponentFactory cfac = (IComponentFactory)cfclass.getConstructor(Object.class).newInstance("rootid");
            IModelInfo model = cfac.loadModel(configfile, null, cl);
            String configname = (String)cmdargs.get(CONFIGURATION_NAME) != null ? (String)cmdargs.get(CONFIGURATION_NAME) : (model.getConfigurations().length > 0 ? model.getConfigurations()[0] : null);
            String platformname = (String)cmdargs.get(PLATFORM_NAME);
            if (platformname == null) {
                IArgument[] cargs = model.getArguments();
                for (int i = 0; i < cargs.length; ++i) {
                    Object argval = cargs[i].getDefaultValue(configname);
                    if (!PLATFORM_NAME.equals(cargs[i].getName())) continue;
                    platformname = (String)argval;
                }
            }
            if (platformname == null) {
                try {
                    platformname = SUtil.createUniqueId((String)InetAddress.getLocalHost().getHostName(), (int)3);
                }
                catch (UnknownHostException e) {
                    platformname = SUtil.createUniqueId((String)"platform", (int)3);
                }
            }
            ComponentIdentifier cid = new ComponentIdentifier(platformname);
            CMSComponentDescription desc = new CMSComponentDescription((IComponentIdentifier)cid, cfac.getComponentType(configfile, null, cl), null, false, false, true, model.getFullName());
            String afclname = (String)cmdargs.get(ADAPTER_FACTORY) != null ? (String)cmdargs.get(ADAPTER_FACTORY) : FALLBACK_ADAPTER_FACTORY;
            Class afclass = SReflect.findClass((String)afclname, null, (ClassLoader)cl);
            IComponentAdapterFactory afac = (IComponentAdapterFactory)afclass.newInstance();
            Future future = new Future();
            final Future ret = new Future();
            future.addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    Object[] root = (Object[])result;
                    IComponentInstance instance = (IComponentInstance)root[0];
                    long startup = System.currentTimeMillis() - starttime;
                    System.out.println("Platform startup time: " + startup + " ms.");
                    ret.setResult((Object)instance.getExternalAccess());
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
            Object[] root = cfac.createComponentInstance((IComponentDescription)desc, afac, model, (String)cmdargs.get(CONFIGURATION_NAME), compargs, null, future);
            IComponentAdapter adapter = (IComponentAdapter)root[1];
            boolean again = true;
            while (again) {
                again = afac.executeStep(adapter);
            }
            adapter.wakeup();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    static {
        RESERVED.add(CONFIGURATION_FILE);
        RESERVED.add(CONFIGURATION_NAME);
        RESERVED.add(PLATFORM_NAME);
        RESERVED.add(COMPONENT_FACTORY);
        RESERVED.add(ADAPTER_FACTORY);
    }
}

