/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.contentcodecs;

import jadex.bridge.IContentCodec;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Properties;

public class JavaXMLContentCodec
implements IContentCodec,
Serializable {
    public static final String JAVA_XML = "java-xml";
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean match(Properties props) {
        return JAVA_XML.equals(props.getProperty("language"));
    }

    public synchronized String encode(Object val, ClassLoader classloader) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(bs);
        e.setExceptionListener(new ExceptionListener(){

            public void exceptionThrown(Exception e) {
                System.out.println("XML encoding ERROR: ");
                e.printStackTrace();
            }
        });
        Thread.currentThread().setContextClassLoader(classloader);
        e.writeObject(val);
        e.close();
        return bs.toString();
    }

    public synchronized Object decode(final String val, ClassLoader classloader) {
        if (!$assertionsDisabled && val == null) {
            throw new AssertionError();
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(val.getBytes());
        XMLDecoder d = new XMLDecoder(bs, null, new ExceptionListener(){

            public void exceptionThrown(Exception e) {
                System.err.println("XML decoding ERROR: " + val);
                e.printStackTrace();
            }
        });
        Thread.currentThread().setContextClassLoader(classloader);
        Object ob = d.readObject();
        d.close();
        return ob;
    }

    static {
        $assertionsDisabled = !JavaXMLContentCodec.class.desiredAssertionStatus();
    }
}

