/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.contentcodecs;

import jadex.bridge.IContentCodec;
import jadex.commons.SReflect;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;

public class NuggetsXMLContentCodec
implements IContentCodec,
Serializable {
    public static final String NUGGETS_XML = "nuggets-xml";
    protected static Method otx;
    protected static Method ofx;

    public static void init(ClassLoader classloader) {
        try {
            Class nug = SReflect.findClass((String)"nuggets.Nuggets", null, (ClassLoader)classloader);
            otx = nug.getMethod("objectToXML", Object.class, ClassLoader.class);
            ofx = nug.getMethod("objectFromXML", String.class, ClassLoader.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Nuggets not in classpath.", e);
        }
    }

    public boolean match(Properties props) {
        return NUGGETS_XML.equals(props.getProperty("language"));
    }

    public String encode(Object val, ClassLoader classloader) {
        if (otx == null) {
            NuggetsXMLContentCodec.init(classloader);
        }
        try {
            return (String)otx.invoke(null, val, classloader);
        }
        catch (Exception e) {
            throw new RuntimeException("Encoding error: " + e);
        }
    }

    public Object decode(String val, ClassLoader classloader) {
        if (otx == null) {
            NuggetsXMLContentCodec.init(classloader);
        }
        try {
            return ofx.invoke(null, val, classloader);
        }
        catch (Exception e) {
            throw new RuntimeException("Decoding error: " + e);
        }
    }
}

