/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.fipa;

import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentIdentifier;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class CMSComponentDescription
implements IComponentDescription,
Cloneable,
Serializable {
    protected String state;
    protected String processingstate;
    protected IComponentIdentifier name;
    protected IComponentIdentifier parent;
    protected Set children;
    protected String ownership;
    protected String type;
    protected String[] breakpoints;
    protected boolean master;
    protected boolean daemon;
    protected boolean autoshutdown;
    protected String modelname;
    Object childmon = new Object();

    public CMSComponentDescription() {
    }

    public CMSComponentDescription(IComponentIdentifier cid, String type, IComponentIdentifier parent, boolean master, boolean daemon, boolean autoshutdown, String modelname) {
        this();
        this.setName(cid);
        this.setType(type);
        this.setParent(parent);
        this.setState("active");
        this.setProcessingState("idle");
        this.setMaster(master);
        this.setDaemon(daemon);
        this.setAutoShutdown(autoshutdown);
        this.setModelName(modelname);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getProcessingState() {
        return this.processingstate;
    }

    public void setProcessingState(String processingstate) {
        this.processingstate = processingstate;
    }

    public IComponentIdentifier getName() {
        return this.name;
    }

    public void setName(IComponentIdentifier name) {
        this.name = name;
    }

    public IComponentIdentifier getParent() {
        return this.parent;
    }

    public void setParent(IComponentIdentifier parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(IComponentIdentifier child) {
        Object object = this.childmon;
        synchronized (object) {
            if (this.children == null) {
                this.children = new LinkedHashSet();
            }
            this.children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(IComponentIdentifier child) {
        Object object = this.childmon;
        synchronized (object) {
            if (this.children != null) {
                this.children.remove(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentIdentifier[] getChildren() {
        Object object = this.childmon;
        synchronized (object) {
            return this.children == null ? new IComponentIdentifier[]{} : this.children.toArray(new IComponentIdentifier[this.children.size()]);
        }
    }

    public String getOwnership() {
        return this.ownership;
    }

    public void setOwnership(String ownership) {
        this.ownership = ownership;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getBreakpoints() {
        return this.breakpoints != null ? this.breakpoints : new String[]{};
    }

    public void setBreakpoints(String[] breakpoints) {
        this.breakpoints = breakpoints;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isAutoShutdown() {
        return this.autoshutdown;
    }

    public void setAutoShutdown(boolean autoshutdown) {
        this.autoshutdown = autoshutdown;
    }

    public String getModelName() {
        return this.modelname;
    }

    public void setModelName(String modelname) {
        this.modelname = modelname;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof CMSComponentDescription && this.getName() != null && this.getName().equals(((CMSComponentDescription)o).getName());
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String toString() {
        return "CMSComponentDescription(name=" + this.getName() + ", state=" + this.getState() + ", ownership=" + this.getOwnership() + ", parent=" + this.getParent() + ")";
    }

    public Object clone() {
        try {
            CMSComponentDescription ret = (CMSComponentDescription)super.clone();
            ret.setName((IComponentIdentifier)((ComponentIdentifier)((ComponentIdentifier)this.name).clone()));
            if (this.children != null) {
                ret.children = new LinkedHashSet();
                ret.children.addAll(this.children);
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Cannot clone: " + this);
        }
    }
}

