/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.fipa;

import jadex.base.fipa.DFServiceDescription;
import jadex.base.fipa.IDFComponentDescription;
import jadex.base.fipa.IDFServiceDescription;
import jadex.bridge.IComponentIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DFComponentDescription
implements IDFComponentDescription,
Serializable {
    protected List languages = new ArrayList();
    protected IComponentIdentifier name;
    protected List ontologies = new ArrayList();
    protected List services = new ArrayList();
    protected Date leasetime;
    protected List protocols = new ArrayList();

    public DFComponentDescription() {
        this(null);
    }

    public DFComponentDescription(IComponentIdentifier name) {
        this(name, null, null, null, null, null);
    }

    public DFComponentDescription(IComponentIdentifier name, IDFServiceDescription[] services, String[] protocols, String[] ontologies, String[] languages, Date leasetime) {
        int i;
        this.setName(name);
        this.setLeaseTime(leasetime);
        if (services != null) {
            for (i = 0; i < services.length; ++i) {
                this.addService(services[i]);
            }
        }
        if (protocols != null) {
            for (i = 0; i < protocols.length; ++i) {
                this.addProtocol(protocols[i]);
            }
        }
        if (languages != null) {
            for (i = 0; i < languages.length; ++i) {
                this.addLanguage(languages[i]);
            }
        }
        if (ontologies != null) {
            for (i = 0; i < ontologies.length; ++i) {
                this.addOntology(ontologies[i]);
            }
        }
    }

    public String[] getLanguages() {
        return this.languages.toArray(new String[this.languages.size()]);
    }

    public void setLanguages(String[] languages) {
        this.languages.clear();
        for (int i = 0; i < languages.length; ++i) {
            this.languages.add(languages[i]);
        }
    }

    public String getLanguage(int idx) {
        return (String)this.languages.get(idx);
    }

    public void setLanguage(int idx, String language) {
        this.languages.set(idx, language);
    }

    public void addLanguage(String language) {
        this.languages.add(language);
    }

    public boolean removeLanguage(String language) {
        return this.languages.remove(language);
    }

    public IComponentIdentifier getName() {
        return this.name;
    }

    public void setName(IComponentIdentifier name) {
        this.name = name;
    }

    public String[] getOntologies() {
        return this.ontologies.toArray(new String[this.ontologies.size()]);
    }

    public void setOntologies(String[] ontologies) {
        this.ontologies.clear();
        for (int i = 0; i < ontologies.length; ++i) {
            this.ontologies.add(ontologies[i]);
        }
    }

    public String getOntology(int idx) {
        return (String)this.ontologies.get(idx);
    }

    public void setOntology(int idx, String ontology) {
        this.ontologies.set(idx, ontology);
    }

    public void addOntology(String ontology) {
        this.ontologies.add(ontology);
    }

    public boolean removeOntology(String ontology) {
        return this.ontologies.remove(ontology);
    }

    public IDFServiceDescription[] getServices() {
        return this.services.toArray(new IDFServiceDescription[this.services.size()]);
    }

    public void setServices(IDFServiceDescription[] services) {
        this.services.clear();
        for (int i = 0; i < services.length; ++i) {
            this.services.add(services[i]);
        }
    }

    public IDFServiceDescription getService(int idx) {
        return (IDFServiceDescription)this.services.get(idx);
    }

    public void setService(int idx, IDFServiceDescription service) {
        this.services.set(idx, service);
    }

    public void addService(IDFServiceDescription service) {
        this.services.add(service);
    }

    public boolean removeService(IDFServiceDescription service) {
        return this.services.remove(service);
    }

    public Date getLeaseTime() {
        return this.leasetime;
    }

    public void setLeaseTime(Date leasetime) {
        this.leasetime = leasetime;
    }

    public String[] getProtocols() {
        return this.protocols.toArray(new String[this.protocols.size()]);
    }

    public void setProtocols(String[] protocols) {
        this.protocols.clear();
        for (int i = 0; i < protocols.length; ++i) {
            this.protocols.add(protocols[i]);
        }
    }

    public String getProtocol(int idx) {
        return (String)this.protocols.get(idx);
    }

    public void setProtocol(int idx, String protocol) {
        this.protocols.set(idx, protocol);
    }

    public void addProtocol(String protocol) {
        this.protocols.add(protocol);
    }

    public boolean removeProtocol(String protocol) {
        return this.protocols.remove(protocol);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DFComponentDescription)) {
            return false;
        }
        DFComponentDescription ad = (DFComponentDescription)obj;
        return DFComponentDescription.eq(ad.name, this.name) && DFComponentDescription.eq(ad.leasetime, this.leasetime) && DFComponentDescription.eq(ad.languages, this.languages) && DFComponentDescription.eq(ad.ontologies, this.ontologies) && DFComponentDescription.eq(ad.protocols, this.protocols) && DFComponentDescription.eq(ad.services, this.services);
    }

    private static final boolean eq(Object a, Object b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    public Object clone() {
        try {
            DFComponentDescription ret = (DFComponentDescription)super.clone();
            ret.services = new ArrayList();
            ret.protocols = (List)((ArrayList)this.protocols).clone();
            ret.languages = (List)((ArrayList)this.languages).clone();
            ret.ontologies = (List)((ArrayList)this.ontologies).clone();
            for (int i = 0; i < this.services.size(); ++i) {
                ret.services.add(((DFServiceDescription)this.services.get(i)).clone());
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Cannot clone: " + this);
        }
    }

    public String toString() {
        return "ComponentDescription(" + this.getName() + (this.leasetime != null ? ", " + this.leasetime.getTime() + ")" : ")");
    }
}

