/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui;

import jadex.base.gui.ComponentIdentifierPanel;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.SGUI;
import jadex.commons.service.IServiceProvider;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class ComponentIdentifierDialog {
    protected Component parent;
    protected IServiceProvider provider;
    protected JDialog dia;
    protected boolean aborted;
    protected IComponentIdentifier cid;

    public ComponentIdentifierDialog(Component parent, IServiceProvider provider) {
        this.parent = parent;
        this.provider = provider;
    }

    public IComponentIdentifier getComponentIdentifier(IComponentIdentifier def) {
        this.dia = this.createDialog(def, this.provider);
        this.aborted = false;
        this.dia.setVisible(true);
        return !this.aborted ? this.cid : null;
    }

    public JDialog createDialog(IComponentIdentifier def, IServiceProvider provider) {
        final ComponentIdentifierPanel pip = new ComponentIdentifierPanel(null, provider);
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        Dimension md = cancel.getMinimumSize();
        Dimension pd = cancel.getPreferredSize();
        ok.setMinimumSize(md);
        ok.setPreferredSize(pd);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentIdentifierDialog.this.cid = pip.cid;
                ComponentIdentifierDialog.this.dia.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentIdentifierDialog.this.aborted = true;
                ComponentIdentifierDialog.this.dia.dispose();
            }
        });
        this.parent = SGUI.getWindowParent((Component)this.parent);
        JDialog dia = this.parent instanceof Frame ? new JDialog((Frame)this.parent, "Enter Component Identifier", true) : new JDialog((Dialog)this.parent, "Enter Component Identifier", true);
        dia.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ComponentIdentifierDialog.this.aborted = true;
            }
        });
        dia.getContentPane().setLayout(new GridBagLayout());
        dia.getContentPane().add((Component)pip, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dia.getContentPane().add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        dia.getContentPane().add((Component)ok, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 4, 4, 2), 0, 0));
        dia.getContentPane().add((Component)cancel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 2), 0, 0));
        dia.pack();
        dia.setLocation(SGUI.calculateMiddlePosition((Window)((Window)this.parent), (Window)dia));
        return dia;
    }
}

