/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui;

import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IMessageService;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.gui.EditableList;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class ComponentIdentifierPanel
extends JPanel {
    protected IServiceProvider provider;
    protected IComponentIdentifier cid;
    protected JTextField tfname;
    protected DocumentListener namelistener;
    protected boolean nameediting;
    protected EditableList taddresses;
    protected boolean editable;
    protected DefaultTableModel schemes;
    static /* synthetic */ Class class$jadex$bridge$IComponentManagementService;

    public ComponentIdentifierPanel(IComponentIdentifier cid, final IServiceProvider provider) {
        this.provider = provider;
        this.cid = cid != null ? cid : new ComponentIdentifier();
        this.editable = true;
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        this.tfname = new JTextField(this.cid.getName(), 20);
        this.namelistener = new NameListener();
        this.tfname.getDocument().addDocumentListener(this.namelistener);
        content.add((Component)new JLabel("Name: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        content.add((Component)this.tfname, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.taddresses = new EditableList("Addresses");
        this.taddresses.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                SServiceProvider.getService((IServiceProvider)provider, (Class)(class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentIdentifierPanel.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService)).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentIdentifierPanel.this){

                    public void customResultAvailable(Object source, Object result) {
                        IComponentManagementService cms = (IComponentManagementService)result;
                        (this).ComponentIdentifierPanel.this.cid = cms.createComponentIdentifier((this).ComponentIdentifierPanel.this.cid.getName(), false, (this).ComponentIdentifierPanel.this.taddresses.getEntries());
                        ComponentIdentifierPanel.this.cidChanged();
                    }
                });
            }
        });
        JScrollPane scroll = new JScrollPane((Component)this.taddresses);
        scroll.setPreferredSize(new Dimension(400, 200));
        content.add((Component)scroll, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.schemes = new DefaultTableModel(new String[]{"Local transport address schemes"}, 0);
        JTable adr = new JTable(this.schemes);
        JPanel help = new JPanel(new BorderLayout());
        help.add((Component)adr.getTableHeader(), "North");
        help.add((Component)adr, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)content, "Center");
        this.add((Component)help, "South");
        SServiceProvider.getService((IServiceProvider)provider, (Class)IMessageService.class).addResultListener((IResultListener)new SwingDefaultResultListener(this){

            public void customResultAvailable(Object source, Object result) {
                IMessageService ms = (IMessageService)result;
                String[] ss = ms.getAddressSchemes();
                for (int i = 0; i < ss.length; ++i) {
                    ComponentIdentifierPanel.this.schemes.addRow(new Object[]{ss[i]});
                }
            }
        });
    }

    protected void cidChanged() {
    }

    public IComponentIdentifier getAgentIdentifier() {
        return this.cid;
    }

    public void setComponentIdentifier(IComponentIdentifier cid) {
        this.cid = cid != null ? cid : new ComponentIdentifier();
        this.refresh();
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            this.editable = editable;
            this.tfname.setEditable(editable);
            this.refresh();
        }
    }

    protected void refresh() {
        if (!this.nameediting) {
            this.tfname.setText(this.cid.getName());
        }
        this.taddresses.setEntries(this.cid.getAddresses());
        this.taddresses.refresh();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public class NameListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        protected void update() {
            SServiceProvider.getService((IServiceProvider)ComponentIdentifierPanel.this.provider, (Class)(class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentIdentifierPanel.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService)).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentIdentifierPanel.this){

                public void customResultAvailable(Object source, Object result) {
                    IComponentManagementService cms = (IComponentManagementService)result;
                    ((NameListener)NameListener.this).ComponentIdentifierPanel.this.nameediting = true;
                    ((NameListener)NameListener.this).ComponentIdentifierPanel.this.cid = cms.createComponentIdentifier(((NameListener)NameListener.this).ComponentIdentifierPanel.this.tfname.getText(), false, ((NameListener)NameListener.this).ComponentIdentifierPanel.this.cid.getAddresses());
                    ComponentIdentifierPanel.this.cidChanged();
                    ((NameListener)NameListener.this).ComponentIdentifierPanel.this.nameediting = false;
                }
            });
        }
    }
}

