/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui;

import jadex.base.gui.ComponentIdentifierPanel;
import jadex.base.gui.componenttree.ComponentTreePanel;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.INodeHandler;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.commons.SGUI;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ComponentSelectorDialog {
    protected static UIDefaults icons = new UIDefaults(new Object[]{"arrow_right", SGUI.makeIcon((Class)ComponentSelectorDialog.class, (String)"/jadex/base/gui/images/arrow_right.png"), "edit_overlay", SGUI.makeIcon((Class)ComponentSelectorDialog.class, (String)"/jadex/base/gui/images/overlay_edit.png")});
    protected Component parent;
    protected IServiceProvider provider;
    protected DefaultListModel sels;
    protected boolean singleselection;
    protected boolean aborted;
    protected JButton select;
    protected JButton newaid;
    protected JButton remove;
    protected JButton removeall;
    protected JButton ok;
    protected ComponentTreePanel comptree;
    static /* synthetic */ Class class$jadex$bridge$IComponentManagementService;

    public ComponentSelectorDialog(Component parent, IServiceProvider provider) {
        this.parent = parent;
        this.provider = provider;
    }

    public IComponentIdentifier selectAgent(IComponentIdentifier def) {
        this.singleselection = true;
        this.sels = new DefaultListModel();
        if (def != null) {
            this.sels.addElement(def);
        }
        JDialog dia = this.createDialog();
        this.aborted = false;
        dia.setVisible(true);
        this.singleselection = false;
        this.comptree.dispose();
        return !this.aborted && this.sels.size() > 0 ? (IComponentIdentifier)this.sels.get(0) : null;
    }

    public IComponentIdentifier[] selectAgents(IComponentIdentifier[] receivers) {
        this.sels = new DefaultListModel();
        for (int i = 0; receivers != null && i < receivers.length; ++i) {
            this.sels.addElement(receivers[i]);
        }
        JDialog dia = this.createDialog();
        this.aborted = false;
        dia.setVisible(true);
        this.comptree.dispose();
        Object[] ret = null;
        if (!this.aborted) {
            ret = new IComponentIdentifier[this.sels.size()];
            this.sels.copyInto(ret);
        }
        return ret;
    }

    protected JDialog createDialog() {
        this.select = new JButton(icons.getIcon("arrow_right"));
        this.newaid = new JButton("New");
        this.remove = new JButton("Delete");
        this.removeall = new JButton("Clear");
        this.ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        JButton help = new JButton("Help");
        this.select.setToolTipText("Use selected agent.");
        this.newaid.setToolTipText("Add new (empty) agent identifier.");
        this.remove.setToolTipText("Remove selected agent.");
        this.removeall.setToolTipText("Remove all agents.");
        this.ok.setToolTipText("Close dialog using current selection.");
        cancel.setToolTipText("Abort dialog.");
        help.setToolTipText("Show online documentation about this dialog.");
        this.select.setMargin(new Insets(1, 1, 1, 1));
        this.newaid.setMinimumSize(cancel.getMinimumSize());
        this.newaid.setPreferredSize(cancel.getPreferredSize());
        this.removeall.setMinimumSize(cancel.getMinimumSize());
        this.removeall.setPreferredSize(cancel.getPreferredSize());
        this.ok.setMinimumSize(cancel.getMinimumSize());
        this.ok.setPreferredSize(cancel.getPreferredSize());
        help.setMinimumSize(cancel.getMinimumSize());
        help.setPreferredSize(cancel.getPreferredSize());
        this.select.setEnabled(false);
        this.newaid.setEnabled(!this.singleselection || this.sels.size() == 0);
        this.remove.setEnabled(false);
        this.removeall.setEnabled(this.sels.size() > 0);
        this.ok.setEnabled(!this.singleselection || this.sels.size() > 0);
        final JList list = new JList(this.sels);
        this.comptree = new ComponentTreePanel(this.provider);
        this.comptree.setPreferredSize(new Dimension(200, 100));
        this.comptree.addNodeHandler(new INodeHandler(){

            public Action[] getPopupActions(IComponentTreeNode[] nodes) {
                return null;
            }

            public Icon getOverlay(IComponentTreeNode node) {
                IComponentIdentifier id;
                Icon ret = null;
                if (node instanceof IActiveComponentTreeNode && ComponentSelectorDialog.this.sels.contains(id = ((IActiveComponentTreeNode)node).getDescription().getName())) {
                    ret = icons.getIcon("edit_overlay");
                }
                return ret;
            }

            public Action getDefaultAction(final IComponentTreeNode node) {
                AbstractAction a = null;
                if (node instanceof IActiveComponentTreeNode) {
                    a = new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            SServiceProvider.getServiceUpwards((IServiceProvider)(this).ComponentSelectorDialog.this.provider, (Class)(class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentSelectorDialog.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService)).addResultListener((IResultListener)new SwingDefaultResultListener((this).ComponentSelectorDialog.this.parent){

                                public void customResultAvailable(Object source, Object result) {
                                    IComponentManagementService cms = (IComponentManagementService)result;
                                    IComponentIdentifier id = ((IActiveComponentTreeNode)node).getDescription().getName();
                                    ComponentSelectorDialog.this.addSelectedAgent(cms.createComponentIdentifier(id.getName(), false, id.getAddresses()), list);
                                    ((this).this).ComponentSelectorDialog.this.comptree.getModel().fireNodeChanged(node);
                                }
                            });
                        }
                    };
                }
                return a;
            }
        });
        JScrollPane sp = new JScrollPane(list);
        sp.setPreferredSize(new Dimension(200, 100));
        final boolean[] editing = new boolean[1];
        final ComponentIdentifierPanel aidpanel = new ComponentIdentifierPanel(null, this.provider){

            protected void cidChanged() {
                if (!list.getSelectionModel().isSelectionEmpty()) {
                    editing[0] = true;
                    int row = list.getSelectedIndex();
                    ComponentSelectorDialog.this.sels.remove(row);
                    ComponentSelectorDialog.this.sels.add(row, this.getAgentIdentifier());
                    list.setSelectedIndex(row);
                    ComponentSelectorDialog.this.comptree.repaint();
                    editing[0] = false;
                }
            }
        };
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!editing[0] && !e.getValueIsAdjusting()) {
                    IComponentIdentifier selected = null;
                    if (!list.getSelectionModel().isSelectionEmpty()) {
                        int row = list.getSelectionModel().getMinSelectionIndex();
                        selected = (IComponentIdentifier)ComponentSelectorDialog.this.sels.get(row);
                    }
                    aidpanel.setComponentIdentifier(selected);
                    aidpanel.setEditable(selected != null);
                    ComponentSelectorDialog.this.remove.setEnabled(selected != null);
                }
            }
        });
        if (this.sels.size() > 0) {
            list.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            aidpanel.setEditable(false);
        }
        JPanel treepanel = new JPanel(new GridBagLayout());
        treepanel.setBorder(new TitledBorder(new EtchedBorder(1), " Known Agents "));
        treepanel.add((Component)this.comptree, new GridBagConstraints(0, 0, 1, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        treepanel.add((Component)this.select, new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        treepanel.add((Component)new JLabel(), new GridBagConstraints(1, 1, 0, 0, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        JPanel seltreepanel = new JPanel(new BorderLayout());
        seltreepanel.add("Center", sp);
        seltreepanel.setBorder(new TitledBorder(new EtchedBorder(1), " Selected Agents "));
        aidpanel.setBorder(new TitledBorder(new EtchedBorder(1), " Agent Identifier "));
        this.comptree.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Object node;
                boolean selectenabled = false;
                if (ComponentSelectorDialog.this.comptree.getTree().getLastSelectedPathComponent() != null && (node = ComponentSelectorDialog.this.comptree.getTree().getLastSelectedPathComponent()) instanceof IActiveComponentTreeNode) {
                    selectenabled = !ComponentSelectorDialog.this.singleselection || ComponentSelectorDialog.this.sels.size() == 0;
                }
                ComponentSelectorDialog.this.select.setEnabled(selectenabled);
            }
        });
        this.parent = SGUI.getWindowParent((Component)this.parent);
        final JDialog dia = this.parent instanceof Frame ? new JDialog((Frame)this.parent, "Select/Enter Agent Identifier", true) : new JDialog((Dialog)this.parent, "Select/Enter Agent Identifier", true);
        dia.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ComponentSelectorDialog.this.aborted = true;
            }
        });
        this.select.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object node;
                if (!ComponentSelectorDialog.this.comptree.getTree().getSelectionModel().isSelectionEmpty() && (node = ComponentSelectorDialog.this.comptree.getTree().getLastSelectedPathComponent()) instanceof IActiveComponentTreeNode) {
                    SServiceProvider.getServiceUpwards((IServiceProvider)ComponentSelectorDialog.this.provider, (Class)(class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentSelectorDialog.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService)).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentSelectorDialog.this.parent){

                        public void customResultAvailable(Object source, Object result) {
                            IComponentManagementService cms = (IComponentManagementService)result;
                            IComponentIdentifier id = ((IActiveComponentTreeNode)node).getDescription().getName();
                            ComponentSelectorDialog.this.addSelectedAgent(cms.createComponentIdentifier(id.getName(), false, id.getAddresses()), list);
                        }
                    });
                }
            }
        });
        this.newaid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SServiceProvider.getServiceUpwards((IServiceProvider)ComponentSelectorDialog.this.provider, (Class)(class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentSelectorDialog.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService)).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentSelectorDialog.this.parent){

                    public void customResultAvailable(Object source, Object result) {
                        IComponentManagementService cms = (IComponentManagementService)result;
                        ComponentSelectorDialog.this.addSelectedAgent(cms.createComponentIdentifier("", true, null), list);
                    }
                });
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!list.getSelectionModel().isSelectionEmpty()) {
                    int row = list.getSelectionModel().getMinSelectionIndex();
                    ComponentSelectorDialog.this.sels.remove(row);
                    ComponentSelectorDialog.this.removeall.setEnabled(ComponentSelectorDialog.this.sels.size() > 0);
                    if (ComponentSelectorDialog.this.singleselection) {
                        ComponentSelectorDialog.this.newaid.setEnabled(true);
                        ComponentSelectorDialog.this.ok.setEnabled(false);
                        if (!ComponentSelectorDialog.this.comptree.getTree().getSelectionModel().isSelectionEmpty()) {
                            ComponentSelectorDialog.this.select.setEnabled(true);
                        }
                    }
                    ComponentSelectorDialog.this.comptree.repaint();
                }
            }
        });
        this.removeall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentSelectorDialog.this.sels.clear();
                ComponentSelectorDialog.this.removeall.setEnabled(false);
                if (ComponentSelectorDialog.this.singleselection) {
                    ComponentSelectorDialog.this.newaid.setEnabled(true);
                    ComponentSelectorDialog.this.ok.setEnabled(false);
                    if (!ComponentSelectorDialog.this.comptree.getTree().getSelectionModel().isSelectionEmpty()) {
                        ComponentSelectorDialog.this.select.setEnabled(true);
                    }
                }
                ComponentSelectorDialog.this.comptree.repaint();
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dia.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentSelectorDialog.this.aborted = true;
                dia.dispose();
            }
        });
        JPanel topright = new JPanel(new GridBagLayout());
        topright.add((Component)seltreepanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topright.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topright.add((Component)this.newaid, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 4, 4, 2), 0, 0));
        topright.add((Component)this.remove, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 2), 0, 0));
        topright.add((Component)this.removeall, new GridBagConstraints(3, 1, 0, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 4), 0, 0));
        JSplitPane right = new JSplitPane(0, true, topright, aidpanel);
        right.setOneTouchExpandable(true);
        right.setResizeWeight(1.0);
        JSplitPane center = new JSplitPane(1, true, treepanel, right);
        center.setOneTouchExpandable(true);
        center.setResizeWeight(0.5);
        dia.getContentPane().setLayout(new GridBagLayout());
        dia.getContentPane().add((Component)center, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dia.getContentPane().add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        dia.getContentPane().add((Component)this.ok, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 4, 4, 2), 0, 0));
        dia.getContentPane().add((Component)cancel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 2), 0, 0));
        dia.getContentPane().add((Component)help, new GridBagConstraints(3, 1, 0, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 4), 0, 0));
        dia.pack();
        dia.setLocation(SGUI.calculateMiddlePosition((Window)((Window)this.parent), (Window)dia));
        return dia;
    }

    protected void addSelectedAgent(IComponentIdentifier agent, JList list) {
        this.removeall.setEnabled(true);
        if (this.singleselection && this.sels.size() > 0) {
            this.sels.removeAllElements();
        }
        this.sels.addElement(agent);
        list.getSelectionModel().setSelectionInterval(this.sels.size() - 1, this.sels.size() - 1);
        if (this.singleselection) {
            this.select.setEnabled(false);
            this.newaid.setEnabled(false);
            this.ok.setEnabled(true);
        }
        this.comptree.repaint();
    }
}

