/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui;

import jadex.commons.BrowserLauncher2;
import jadex.commons.SGUI;
import jadex.commons.SUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;

public class JadexLogoButton
extends JButton {
    private static UIDefaults icons = new UIDefaults(new Object[]{"JadexLogo", SGUI.makeIcon((Class)JadexLogoButton.class, (String)"/jadex/base/gui/images/jadexlogo.png"), "JadexLogoV", SGUI.makeIcon((Class)JadexLogoButton.class, (String)"/jadex/base/gui/images/jadexlogoV.png")});
    private final JToolBar tb;
    private int last_orient;

    public JadexLogoButton(final JToolBar tb) {
        super(icons.getIcon("JadexLogo"));
        this.tb = tb;
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setToolTipText("Go to Jadex Home Page");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher2.openURL((String)"http://vsis-www.informatik.uni-hamburg.de/projects/jadex");
                }
                catch (IOException ex) {
                    String txt = SUtil.wrapText((String)("Could not open URL in browser\n\n" + ex.getMessage()));
                    JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)tb), txt, "Browser Error", 0);
                }
            }
        });
        this.last_orient = tb.getOrientation();
    }

    public Dimension getPreferredSize() {
        int orient = this.tb.getOrientation();
        if (orient != this.last_orient) {
            switch (this.tb.getOrientation()) {
                case 0: {
                    this.setIcon(icons.getIcon("JadexLogo"));
                    break;
                }
                case 1: {
                    this.setIcon(icons.getIcon("JadexLogoV"));
                }
            }
            this.last_orient = orient;
        }
        return super.getPreferredSize();
    }
}

