/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui;

import jadex.base.gui.ObjectTreeModel;
import jadex.commons.TreeExpansionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ObjectInspectorPanel
extends JPanel {
    public ObjectInspectorPanel(Object root) {
        super(new BorderLayout());
        final ObjectTreeModel model = new ObjectTreeModel(root);
        final JTree tree = new JTree(model);
        model.addTreeModelListener(new TreeModelListener(){

            public void treeStructureChanged(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
                Object[] treepath = e.getPath();
                if (treepath != null && treepath.length == 1 && e.getChildren().length == 1) {
                    tree.expandPath(new TreePath(model.getRoot()));
                }
            }

            public void treeNodesChanged(TreeModelEvent e) {
            }
        });
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);
        new TreeExpansionHandler(tree);
        tree.setCellRenderer(new ObjectTreeModel.ObjectTreeCellRenderer());
        this.add((Component)new JScrollPane(tree), "Center");
    }

    public static JFrame createObjectFrame(String title, Object root) {
        JFrame frame = new JFrame(title);
        frame.getContentPane().add((Component)new ObjectInspectorPanel(root), "Center");
        frame.setSize(600, 400);
        return frame;
    }

    public static void main(String[] args) {
        JFrame f = ObjectInspectorPanel.createObjectFrame("test", new JFrame());
        f.setVisible(true);
    }
}

