/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui;

import jadex.base.gui.ObjectInspectorRefreshAction;
import jadex.commons.SGUI;
import jadex.commons.SUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ObjectTreeModel
implements TreeModel {
    protected static final boolean enableObjectInspection = true;
    protected static UIDefaults icons;
    protected ObjectInspectorNode root;
    protected Set listeners;
    protected boolean notify;
    protected List inspectors;
    protected int uuidcounter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ObjectTreeModel(Object root) {
        this.root = new ObjectInspectorNode(null, root.getClass(), null, root);
        this.inspectors = new ArrayList();
        this.uuidcounter = 0;
        Timer timer = new Timer(5000, new ObjectInspectorRefreshAction(this));
        timer.start();
    }

    public Object getRoot() {
        return this.root;
    }

    public int getChildCount(Object parent) {
        int count = parent instanceof ObjectInspectorNode ? ((ObjectInspectorNode)parent).getChildren().size() : (parent instanceof ObjectInspectorAttributeNode ? ((ObjectInspectorAttributeNode)parent).getChildren().size() : 0);
        return count;
    }

    public Object getChild(Object parent, int index) {
        Object ret;
        if (parent instanceof ObjectInspectorNode) {
            ret = ((ObjectInspectorNode)parent).getChildren().get(index);
        } else if (parent instanceof ObjectInspectorAttributeNode) {
            ret = ((ObjectInspectorAttributeNode)parent).getChildren().get(index);
        } else {
            throw new IllegalArgumentException("Node has no children: " + parent);
        }
        return ret;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int index = -1;
        int count = this.getChildCount(parent);
        for (int i = 0; index == -1 && i < count; ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            index = i;
        }
        return index;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected synchronized int getNextNodeUUID() {
        return ++this.uuidcounter;
    }

    protected void fireTreeStructureChanged(Object[] treePath) {
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath);
        if (this.listeners != null) {
            TreeModelListener[] alisteners = this.listeners.toArray(new TreeModelListener[this.listeners.size()]);
            for (int i = 0; i < alisteners.length; ++i) {
                alisteners[i].treeStructureChanged(event);
            }
        }
    }

    protected boolean testInspectorNodesListEquals(List l1, List l2) {
        if (l1 == l2) {
            return true;
        }
        if (!(l1 instanceof List) || !(l2 instanceof List)) {
            return false;
        }
        ListIterator e1 = l1.listIterator();
        ListIterator e2 = l2.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            try {
                if (o1 != null ? ((AbstractInspectorNode)o1).equals(o2, false) : o2 == null) continue;
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    protected int getIndexForChild(List children, Object child) {
        return this.getIndexForChild(children, child, 0);
    }

    protected int getIndexForChild(List children, Object child, int start) {
        if (!$assertionsDisabled && children == null) {
            throw new AssertionError();
        }
        int index = -1;
        for (int i = start; index == -1 && i < children.size(); ++i) {
            if (children.get(i) instanceof ObjectInspectorNode && ((ObjectInspectorNode)children.get(i)).equals(child, false)) {
                index = i;
                continue;
            }
            if (children.get(i) instanceof ObjectInspectorAttributeNode && ((ObjectInspectorAttributeNode)children.get(i)).equals(child, false)) {
                index = i;
                continue;
            }
            if (children.get(i) instanceof ObjectInspectorValueNode && ((ObjectInspectorValueNode)children.get(i)).equals(child, false)) {
                index = i;
                continue;
            }
            if (!children.get(i).equals(child)) continue;
            index = i;
        }
        return index;
    }

    protected void refreshInspectorNodes() {
        TreeModelEvent event = null;
        Object[] inspectorNodes = this.inspectors.toArray(new Object[this.inspectors.size()]);
        for (int inspectorIndex = inspectorNodes.length - 1; inspectorIndex >= 0; --inspectorIndex) {
            if (inspectorNodes[inspectorIndex] instanceof ObjectInspectorAttributeNode) {
                ObjectInspectorAttributeNode node = (ObjectInspectorAttributeNode)inspectorNodes[inspectorIndex];
                if (node.children == null) continue;
                List oldchildren = node.children;
                node.children = null;
                List newchildren = node.getChildren();
                node.children = oldchildren;
                if (node.isArrayNode()) {
                    int i;
                    if (!ObjectTreeModel.isInspectable(node.type.getComponentType(), true)) {
                        if (this.testInspectorNodesListEquals(oldchildren, newchildren)) continue;
                        node.children = newchildren;
                        this.fireTreeStructureChanged(node.getPath());
                        continue;
                    }
                    ArrayList prevSelectedChildren = new ArrayList();
                    TreeMap removedChildren = new TreeMap();
                    for (int i2 = 0; i2 < oldchildren.size(); ++i2) {
                        Object oldchild = oldchildren.get(i2);
                        int index = this.getIndexForChild(newchildren, oldchild, 0);
                        while (index != -1 && prevSelectedChildren.contains(newchildren.get(index))) {
                            prevSelectedChildren.add(newchildren.get(index));
                            index = this.getIndexForChild(newchildren, oldchild, index + 1);
                        }
                        if (index != -1) continue;
                        removedChildren.put(new Integer(i2), oldchild);
                    }
                    prevSelectedChildren.clear();
                    Object[] removed = removedChildren.entrySet().toArray();
                    int[] indexes = new int[removed.length];
                    Object[] childs = new Object[removed.length];
                    for (int i3 = 0; i3 < removed.length; ++i3) {
                        Map.Entry entry = (Map.Entry)removed[i3];
                        indexes[i3] = (Integer)entry.getKey();
                        childs[i3] = entry.getValue();
                        oldchildren.remove(entry.getValue());
                    }
                    TreeMap insertedChildren = new TreeMap();
                    for (i = 0; i < newchildren.size(); ++i) {
                        Object newchild = newchildren.get(i);
                        int index = this.getIndexForChild(oldchildren, newchild, 0);
                        while (index != -1 && prevSelectedChildren.contains(newchildren.get(index))) {
                            prevSelectedChildren.add(oldchildren.get(index));
                            index = this.getIndexForChild(oldchildren, newchild, index + 1);
                        }
                        if (index != -1) {
                            Object oldchild = oldchildren.get(index);
                            oldchildren.remove(index);
                            newchildren.remove(i);
                            newchildren.add(i, oldchild);
                            continue;
                        }
                        insertedChildren.put(new Integer(i), newchild);
                    }
                    prevSelectedChildren.clear();
                    for (i = 0; i < newchildren.size(); ++i) {
                        Object obj = newchildren.get(i);
                        if (obj instanceof ObjectInspectorNode) {
                            ((ObjectInspectorNode)obj).namePrefix = "[" + i + "] ";
                            continue;
                        }
                        if (!(obj instanceof ObjectInspectorValueNode)) continue;
                        ((ObjectInspectorValueNode)obj).namePrefix = "[" + i + "] ";
                    }
                    Object[] inserted = insertedChildren.entrySet().toArray();
                    int[] insertedIndexes = new int[inserted.length];
                    Object[] insertedChilds = new Object[inserted.length];
                    for (int insertedIndex = 0; insertedIndex < inserted.length; ++insertedIndex) {
                        Map.Entry entry = (Map.Entry)inserted[insertedIndex];
                        insertedIndexes[insertedIndex] = (Integer)entry.getKey();
                        insertedChilds[insertedIndex] = entry.getValue();
                    }
                    node.children = newchildren;
                    TreeModelListener[] alisteners = this.listeners.toArray(new TreeModelListener[this.listeners.size()]);
                    if (removedChildren.size() > 0) {
                        event = new TreeModelEvent((Object)this, node.getPath(), indexes, childs);
                        for (int i4 = 0; i4 < alisteners.length; ++i4) {
                            alisteners[i4].treeNodesRemoved(event);
                        }
                    }
                    if (insertedChildren.size() <= 0) continue;
                    event = new TreeModelEvent((Object)this, node.getPath(), insertedIndexes, insertedChilds);
                    for (int i5 = 0; i5 < alisteners.length; ++i5) {
                        alisteners[i5].treeNodesInserted(event);
                    }
                    continue;
                }
                if (!$assertionsDisabled && oldchildren.size() != newchildren.size()) {
                    throw new AssertionError(node);
                }
                if (!$assertionsDisabled && newchildren.size() != 1) {
                    throw new AssertionError(node);
                }
                if (this.getIndexForChild(oldchildren, newchildren.get(0)) != -1) continue;
                node.children = newchildren;
                if (oldchildren.get(0) instanceof ObjectInspectorNode || newchildren.get(0) instanceof ObjectInspectorNode) {
                    this.fireTreeStructureChanged((Object[])SUtil.joinArrays((Object)node.getPath(), (Object)new Object[]{oldchildren.get(0)}));
                    continue;
                }
                event = new TreeModelEvent((Object)this, node.getPath(), new int[]{0}, new Object[]{oldchildren.get(0)});
                TreeModelListener[] alisteners = this.listeners.toArray(new TreeModelListener[this.listeners.size()]);
                for (int i = 0; i < alisteners.length; ++i) {
                    alisteners[i].treeNodesChanged(event);
                }
                continue;
            }
            if (inspectorNodes[inspectorIndex] == null) continue;
            System.err.println("Error in ObjectInspectorTreeModel, unknown inspector node type: " + inspectorNodes[inspectorIndex]);
        }
    }

    protected static boolean isInspectable(Object obj) {
        boolean ret;
        boolean bl = ret = obj != null;
        if (ret) {
            ret = ret && !(obj instanceof String);
            ret = ret && !(obj instanceof Number);
            ret = ret && !(obj instanceof Character);
            boolean bl2 = ret = ret && !(obj instanceof Boolean);
            ret = ret && obj.getClass() != Object.class;
        }
        return ret;
    }

    protected static boolean isInspectable(Class clazz, boolean inspectObjectClass) {
        boolean ret;
        boolean bl = ret = clazz != null;
        if (ret) {
            boolean bl2 = ret && clazz.isAssignableFrom(String.class) ? true : (ret = false);
            boolean bl3 = ret && clazz.isAssignableFrom(Number.class) ? true : (ret = false);
            boolean bl4 = ret && clazz.isAssignableFrom(Character.class) ? true : (ret = false);
            boolean bl5 = ret && clazz.isAssignableFrom(Boolean.class) ? true : (ret = false);
            if (!inspectObjectClass) {
                ret = ret && clazz != Object.class;
            }
        }
        return ret;
    }

    static {
        $assertionsDisabled = !ObjectTreeModel.class.desiredAssertionStatus();
        icons = new UIDefaults(new Object[]{"javaobject", SGUI.makeIcon((Class)ObjectTreeModel.class, (String)"/jadex/base/gui/images/bean.png"), "javaattribute", SGUI.makeIcon((Class)ObjectTreeModel.class, (String)"/jadex/base/gui/images/attribute.png"), "javavalue", SGUI.makeIcon((Class)ObjectTreeModel.class, (String)"/jadex/base/gui/images/value.png")});
    }

    public static class ObjectTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof ObjectInspectorNode) {
                this.setIcon(icons.getIcon("javaobject"));
            } else if (value instanceof ObjectInspectorAttributeNode) {
                this.setIcon(icons.getIcon("javaattribute"));
            } else if (value instanceof ObjectInspectorValueNode) {
                this.setIcon(icons.getIcon("javavalue"));
            } else {
                this.setIcon(icons.getIcon("value"));
            }
            return this;
        }

        public Dimension getPreferredSize() {
            Dimension d = new Dimension(super.getPreferredSize());
            d.setSize(d.getWidth() + 10.0, d.getHeight());
            return d;
        }
    }

    class ObjectInspectorValueNode
    extends AbstractInspectorNode {
        protected String namePrefix;
        protected Object value;

        public ObjectInspectorValueNode(Object parent, String namePrefix, Object value) {
            this.parent = parent;
            this.namePrefix = namePrefix;
            this.value = value;
        }

        public List getChildren() {
            return null;
        }

        public Object[] getPath() {
            return (Object[])SUtil.joinArrays((Object)((AbstractInspectorNode)this.parent).getPath(), (Object)new Object[]{this});
        }

        protected boolean equals(Object obj, boolean checkUUID) {
            boolean ret;
            boolean bl = obj instanceof ObjectInspectorValueNode && ((ObjectInspectorValueNode)obj).parent == this.parent && (this.value == null ? ((ObjectInspectorValueNode)obj).value == null : this.value.equals(((ObjectInspectorValueNode)obj).value)) ? true : (ret = false);
            if (checkUUID && ret) {
                ret = ret && ((ObjectInspectorValueNode)obj).nodeUUID == this.nodeUUID;
            }
            return ret;
        }

        public boolean equals(Object obj) {
            return this.equals(obj, true);
        }

        public int hashCode() {
            return this.nodeUUID;
        }

        public String toString() {
            String ret = (this.namePrefix != null ? this.namePrefix : "") + (this.value != null ? this.value : "null");
            return ret;
        }
    }

    class ObjectInspectorAttributeNode
    extends AbstractInspectorNode {
        protected Field field;
        protected Class type;
        protected String name;
        protected Object attributeValue;

        public ObjectInspectorAttributeNode(ObjectInspectorNode parent, Field f, String name) throws IllegalAccessException {
            this.parent = parent;
            this.field = f;
            this.type = f.getType();
            this.name = name != null ? name : f.getName();
            ObjectTreeModel.this.inspectors.add(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public List getChildren() {
            if (this.children != null) return this.children;
            this.children = new ArrayList();
            if (this.isArrayNode()) {
                try {
                    this.attributeValue = this.getFieldValue();
                    if (this.attributeValue == null) return this.children;
                    for (int i = 0; i < Array.getLength(this.attributeValue); ++i) {
                        Object obj = Array.get(this.attributeValue, i);
                        if (ObjectTreeModel.isInspectable(obj)) {
                            this.children.add(new ObjectInspectorNode(this, obj.getClass(), "[" + i + "] ", null, obj));
                            continue;
                        }
                        this.children.add(new ObjectInspectorValueNode(this, "[" + i + "] ", obj));
                    }
                    return this.children;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.children.add("-ERROR- Exception occurred: " + e);
                    return this.children;
                }
            } else {
                this.attributeValue = this.getFieldValue();
                if (ObjectTreeModel.isInspectable(this.attributeValue)) {
                    this.children.add(new ObjectInspectorNode(this, this.type, this.name, this.attributeValue));
                    return this.children;
                } else {
                    this.children.add(new ObjectInspectorValueNode(this, null, this.attributeValue));
                }
            }
            return this.children;
        }

        protected boolean isArrayNode() {
            this.attributeValue = this.getFieldValue();
            return this.type.isArray() || this.attributeValue != null && this.attributeValue.getClass().isArray();
        }

        protected Object getFieldValue() {
            try {
                return this.field.get(((ObjectInspectorNode)this.parent).getNodeObject());
            }
            catch (Exception e) {
                return "-ERROR- Exception occurred: " + e;
            }
        }

        protected Object getArrayValue() {
            try {
                if (this.isArrayNode()) {
                    return Array.get(this.field.get(((ObjectInspectorNode)this.parent).getNodeObject()), ((ObjectInspectorNode)this.parent).getChildren().indexOf(this));
                }
                return "-ERROR- getArrayValue called on a non array type";
            }
            catch (Exception e) {
                return "-ERROR- Exception occurred: " + e;
            }
        }

        public Object[] getPath() {
            if (this.path == null) {
                this.path = this.parent != null ? (Object[])SUtil.joinArrays((Object)((ObjectInspectorNode)this.parent).getPath(), (Object)new Object[]{this}) : new Object[]{this};
            }
            return this.path;
        }

        protected boolean equals(Object obj, boolean checkUUID) {
            boolean ret;
            boolean bl = ret = obj instanceof ObjectInspectorAttributeNode && ((ObjectInspectorAttributeNode)obj).parent == this.parent && ((ObjectInspectorAttributeNode)obj).field == this.field && ((ObjectInspectorAttributeNode)obj).name == this.name;
            if (ret) {
                Object objValue = ((ObjectInspectorAttributeNode)obj).attributeValue;
                if (this.type.isPrimitive()) {
                    ret = this.attributeValue == null ? objValue == null : this.attributeValue.equals(objValue);
                } else {
                    boolean bl2 = ret = this.attributeValue == objValue;
                }
            }
            if (checkUUID && ret) {
                ret = ret && ((ObjectInspectorAttributeNode)obj).nodeUUID == this.nodeUUID;
            }
            return ret;
        }

        public boolean equals(Object obj) {
            return this.equals(obj, true);
        }

        public int hashCode() {
            return this.nodeUUID;
        }

        public String toString() {
            String len = "";
            try {
                if (this.isArrayNode()) {
                    Object arrayValue = this.getFieldValue();
                    len = arrayValue != null ? "" + Array.getLength(arrayValue) : "null";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                len = "-ERROR-";
            }
            return (this.name != null ? this.name : "?? INVALID NODE NAME ??") + (this.isArrayNode() ? "[" + len + "]" : "");
        }
    }

    public class ObjectInspectorNode
    extends AbstractInspectorNode {
        protected Class type;
        protected Object nodeObject;
        protected List fields;
        protected String name;
        protected String namePrefix;

        public ObjectInspectorNode(Object parent, Class type, String name, Object object) {
            this(parent, type, null, name, object);
        }

        public ObjectInspectorNode(Object parent, Class type, String namePrefix, String name, Object object) {
            this.parent = parent;
            this.type = type;
            this.name = name;
            this.namePrefix = namePrefix;
            this.nodeObject = object;
            this.getFields();
        }

        public List getFields() {
            if (this.fields == null) {
                this.fields = new ArrayList();
                if (!(this.type.isPrimitive() || this.type.isArray() || this.type.equals(class$java$lang$String == null ? (class$java$lang$String = ObjectTreeModel.class$("java.lang.String")) : class$java$lang$String) || this.nodeObject == null)) {
                    for (Class<?> clazz = this.nodeObject.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                        AccessibleObject[] f = clazz.getDeclaredFields();
                        AccessibleObject.setAccessible(f, true);
                        for (int i = 0; i < f.length; ++i) {
                            if ((((Field)f[i]).getModifiers() & 8) != 0) continue;
                            this.fields.add(f[i]);
                        }
                    }
                }
            }
            return this.fields;
        }

        public List getChildren() {
            if (this.children == null) {
                this.children = new ArrayList();
                Iterator it = this.fields.iterator();
                while (it.hasNext()) {
                    Field f = (Field)it.next();
                    try {
                        this.children.add(new ObjectInspectorAttributeNode(this, f, null));
                    }
                    catch (IllegalAccessException e) {
                        this.children.add("-ERROR- Exception occurred: " + e);
                    }
                }
            }
            return this.children;
        }

        public Object[] getPath() {
            if (this.path == null) {
                this.path = this.parent != null ? (this.parent instanceof ObjectInspectorAttributeNode ? (Object[])SUtil.joinArrays((Object)((ObjectInspectorAttributeNode)this.parent).getPath(), (Object)new Object[]{this}) : new Object[]{this.parent, this}) : new Object[]{this};
            }
            return this.path;
        }

        protected Object getNodeObject() {
            return this.nodeObject;
        }

        protected boolean isInpsectionRootNode() {
            return !(this.parent instanceof ObjectInspectorAttributeNode);
        }

        protected boolean equals(Object obj, boolean checkUUID) {
            boolean ret;
            boolean bl = ret = obj instanceof ObjectInspectorNode && ((ObjectInspectorNode)obj).parent == this.parent && ((ObjectInspectorNode)obj).type == this.type && ((ObjectInspectorNode)obj).name == this.name && this.fields != null && ((Object)this.fields).equals(((ObjectInspectorNode)obj).fields) && this.nodeObject != null && this.nodeObject.equals(((ObjectInspectorNode)obj).nodeObject);
            if (checkUUID && ret) {
                ret = ret && ((ObjectInspectorNode)obj).nodeUUID == this.nodeUUID;
            }
            return ret;
        }

        public boolean equals(Object obj) {
            return this.equals(obj, true);
        }

        public int hashCode() {
            return this.nodeUUID;
        }

        public String toString() {
            this.getNodeObject();
            return (this.namePrefix != null ? this.namePrefix : "") + (this.name != null ? this.name : "") + (this.nodeObject != null ? this.nodeObject.toString() : "null");
        }
    }

    abstract class AbstractInspectorNode {
        protected Object parent;
        protected List children;
        protected Object[] path;
        protected int nodeUUID;

        protected AbstractInspectorNode() {
            this.nodeUUID = ObjectTreeModel.this.getNextNodeUUID();
        }

        public abstract List getChildren();

        public abstract Object[] getPath();

        protected abstract boolean equals(Object var1, boolean var2);

        public int hashCode() {
            return this.nodeUUID;
        }
    }
}

