/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.commons.Future;
import jadex.commons.IFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public abstract class AbstractComponentTreeNode
implements IComponentTreeNode {
    private final IComponentTreeNode parent;
    private final ComponentTreeModel model;
    private final JTree tree;
    private List children;
    private boolean searching;
    private boolean recurse;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractComponentTreeNode(IComponentTreeNode parent, ComponentTreeModel model, JTree tree) {
        this.parent = parent;
        this.model = model;
        this.tree = tree;
    }

    public void dispose() {
    }

    public IComponentTreeNode getParent() {
        return this.parent;
    }

    public int getChildCount() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.children == null && !this.searching) {
            this.searching = true;
            this.searchChildren(false);
        }
        return this.children == null ? 0 : this.children.size();
    }

    public IComponentTreeNode getChild(int index) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.children == null && !this.searching) {
            this.searching = true;
            this.searchChildren(false);
        }
        return this.children == null ? null : (IComponentTreeNode)this.children.get(index);
    }

    public int getIndexOfChild(IComponentTreeNode child) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.children == null && !this.searching) {
            this.searching = true;
            this.searchChildren(false);
        }
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public boolean isLeaf() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.getChildCount() == 0;
    }

    public void refresh(boolean recurse, boolean force) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.searching) {
            this.searching = true;
            this.recurse = recurse;
            this.searchChildren(force);
        } else {
            this.recurse = this.recurse || recurse;
        }
    }

    public List getCachedChildren() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.children != null ? this.children : Collections.EMPTY_LIST;
    }

    public boolean hasProperties() {
        return false;
    }

    public JComponent getPropertiesComponent() {
        throw new UnsupportedOperationException("Node has no properties: " + this);
    }

    public abstract Icon getIcon();

    protected abstract void searchChildren(boolean var1);

    protected IFuture setChildren(final List children) {
        final Future ret = new Future();
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            final RuntimeException rte = e;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int i;
                    boolean dorecurse = AbstractComponentTreeNode.this.recurse;
                    AbstractComponentTreeNode.this.searching = false;
                    AbstractComponentTreeNode.this.recurse = false;
                    List oldcs = AbstractComponentTreeNode.this.children;
                    AbstractComponentTreeNode.this.children = children;
                    ArrayList added = new ArrayList();
                    ArrayList removed = new ArrayList();
                    if (oldcs != null) {
                        removed.addAll(oldcs);
                    }
                    if (children != null) {
                        added.addAll(children);
                        removed.removeAll(children);
                    }
                    if (oldcs != null) {
                        added.removeAll(oldcs);
                    }
                    try {
                        IComponentTreeNode node;
                        if (!added.isEmpty() && !removed.isEmpty()) {
                            for (i = 0; oldcs != null && i < oldcs.size(); ++i) {
                                AbstractComponentTreeNode.this.model.deregisterNode((IComponentTreeNode)oldcs.get(i));
                            }
                            for (i = 0; children != null && i < children.size(); ++i) {
                                AbstractComponentTreeNode.this.model.addNode((IComponentTreeNode)children.get(i));
                            }
                            AbstractComponentTreeNode.this.model.fireTreeChanged(AbstractComponentTreeNode.this);
                        } else if (!added.isEmpty()) {
                            for (i = 0; i < added.size(); ++i) {
                                node = (IComponentTreeNode)added.get(i);
                                AbstractComponentTreeNode.this.model.addNode(node);
                                AbstractComponentTreeNode.this.model.fireNodeAdded(AbstractComponentTreeNode.this, node, children.indexOf(node));
                            }
                            AbstractComponentTreeNode.this.model.fireNodeChanged(AbstractComponentTreeNode.this);
                        } else if (!removed.isEmpty()) {
                            for (i = removed.size() - 1; i >= 0; --i) {
                                node = (IComponentTreeNode)removed.get(i);
                                AbstractComponentTreeNode.this.model.deregisterNode(node);
                                AbstractComponentTreeNode.this.model.fireNodeRemoved(AbstractComponentTreeNode.this, node, oldcs.indexOf(node));
                            }
                            AbstractComponentTreeNode.this.model.fireNodeChanged(AbstractComponentTreeNode.this);
                        }
                    }
                    catch (RuntimeException e) {
                        System.err.println("node problem: " + AbstractComponentTreeNode.this + "#" + AbstractComponentTreeNode.this.hashCode());
                        System.err.println("added: " + added);
                        System.err.println("removed: " + removed);
                        System.err.println("children: " + children);
                        System.err.println("oldcs: " + oldcs);
                        rte.printStackTrace();
                        throw e;
                    }
                    if (dorecurse && AbstractComponentTreeNode.this.tree.isExpanded(new TreePath(AbstractComponentTreeNode.this.model.buildTreePath(AbstractComponentTreeNode.this).toArray()))) {
                        for (i = 0; children != null && i < children.size(); ++i) {
                            ((IComponentTreeNode)children.get(i)).refresh(dorecurse, false);
                        }
                    }
                    ret.setResult(null);
                }
            });
            return ret;
        }
    }

    public ComponentTreeModel getModel() {
        return this.model;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void addChild(int index, IComponentTreeNode node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.model.isZombieNode(node.getId())) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(index, node);
            this.model.addNode(node);
            this.model.fireNodeAdded(this, node, index);
        } else {
            this.model.deregisterNode(node);
        }
    }

    public void addChild(IComponentTreeNode node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.addChild(this.getChildCount(), node);
    }

    public void removeChild(IComponentTreeNode node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        int index = this.getIndexOfChild(node);
        if (index != -1) {
            this.children.remove(node);
            this.model.deregisterNode(node);
            this.model.fireNodeRemoved(this, node, index);
        }
    }

    static {
        $assertionsDisabled = !AbstractComponentTreeNode.class.desiredAssertionStatus();
    }
}

