/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.bridge.ComponentFactorySelector;
import jadex.bridge.IComponentFactory;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.service.IResultSelector;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;

public class ComponentIconCache {
    private final Map icons = new HashMap();
    private final IServiceProvider provider;
    private final JTree tree;

    public ComponentIconCache(IServiceProvider provider, JTree tree) {
        this.provider = provider;
        this.tree = tree;
    }

    public Icon getIcon(final IComponentTreeNode node, final String type) {
        Icon ret = null;
        if (this.icons.containsKey(type)) {
            ret = (Icon)this.icons.get(type);
        } else {
            SServiceProvider.getService((IServiceProvider)this.provider, (IResultSelector)new ComponentFactorySelector(type)).addResultListener((IResultListener)new SwingDefaultResultListener(){

                public void customResultAvailable(Object source, Object result) {
                    IComponentFactory fac = (IComponentFactory)result;
                    ComponentIconCache.this.icons.put(type, fac.getComponentTypeIcon(type));
                    TreeModel model = ComponentIconCache.this.tree.getModel();
                    if (model instanceof ComponentTreeModel) {
                        ((ComponentTreeModel)model).fireNodeChanged(node);
                    } else {
                        ComponentIconCache.this.tree.repaint();
                    }
                }

                public void customExceptionOccurred(Object source, Exception exception) {
                }
            });
        }
        return ret;
    }
}

