/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.INodeHandler;
import jadex.commons.gui.CombiIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ComponentTreeCellRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        IComponentTreeNode node = (IComponentTreeNode)value;
        Icon icon = node.getIcon();
        if (tree.getModel() instanceof ComponentTreeModel) {
            ArrayList<Icon> icons = null;
            INodeHandler[] handlers = ((ComponentTreeModel)tree.getModel()).getNodeHandlers();
            for (int i = 0; handlers != null && i < handlers.length; ++i) {
                Icon overlay = handlers[i].getOverlay(node);
                if (overlay == null) continue;
                if (icons == null) {
                    icons = new ArrayList<Icon>();
                    if (icon != null) {
                        icons.add(icon);
                    }
                }
                icons.add(overlay);
            }
            if (icons != null) {
                icon = new CombiIcon(icons.toArray(new Icon[icons.size()]));
            }
        }
        if (icon != null) {
            this.setOpenIcon(icon);
            this.setClosedIcon(icon);
            this.setLeafIcon(icon);
        } else {
            this.setOpenIcon(this.getDefaultOpenIcon());
            this.setClosedIcon(this.getDefaultClosedIcon());
            this.setLeafIcon(this.getDefaultLeafIcon());
        }
        JComponent comp = (JComponent)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        return comp;
    }

    public void paint(Graphics g) {
        if (this.getBackground() != null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }
}

