/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.INodeHandler;
import jadex.base.gui.componenttree.INodeListener;
import jadex.commons.collection.MultiCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ComponentTreeModel
implements TreeModel {
    private IComponentTreeNode root;
    private final List listeners = new ArrayList();
    private final List nodelisteners = new ArrayList();
    private final Map nodes = new HashMap();
    private final Map added = new HashMap();
    private final Set zombies = new HashSet();
    private final List overlays = new ArrayList();
    private MultiCollection changed;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object getRoot() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return ((IComponentTreeNode)parent).getChild(index);
    }

    public int getChildCount(Object parent) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return ((IComponentTreeNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return ((IComponentTreeNode)parent).getIndexOfChild((IComponentTreeNode)child);
    }

    public boolean isLeaf(Object node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return ((IComponentTreeNode)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        throw new UnsupportedOperationException("Component Tree is not editable.");
    }

    public void addTreeModelListener(TreeModelListener l) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.listeners.remove(l);
    }

    public void setRoot(IComponentTreeNode root) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.root != null) {
            this.deregisterNode(this.root);
        }
        this.root = root;
        if (root != null) {
            this.addNode(root);
        }
        this.fireTreeChanged(root);
    }

    public void fireTreeChanged(IComponentTreeNode node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        List path = this.buildTreePath(node);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeStructureChanged(new TreeModelEvent((Object)this, path.toArray()));
        }
    }

    public void fireNodeChanged(IComponentTreeNode node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.changed == null) {
            this.changed = new MultiCollection(new HashMap(), HashSet.class);
            this.changed.put((Object)node.getParent(), (Object)node);
            IComponentTreeNode[] parents = (IComponentTreeNode[])this.changed.getKeys(IComponentTreeNode.class);
            for (int i = 0; i < parents.length; ++i) {
                int[] indices;
                Object[] nodes;
                if (parents[i] != null && this.getAddedNode(parents[i].getId()) == null) continue;
                boolean skip = false;
                Set set = (Set)this.changed.get((Object)parents[i]);
                List path = null;
                if (parents[i] != null) {
                    int cnt = 0;
                    nodes = new Object[set.size()];
                    indices = new int[nodes.length];
                    Iterator it = set.iterator();
                    for (int j = 0; j < nodes.length; ++j) {
                        nodes[cnt] = it.next();
                        if (this.getAddedNode(((IComponentTreeNode)nodes[cnt]).getId()) == null) continue;
                        indices[cnt] = parents[i].getIndexOfChild((IComponentTreeNode)nodes[cnt]);
                        if (indices[cnt] == -1) continue;
                        ++cnt;
                    }
                    if (cnt == 0) {
                        skip = true;
                    } else {
                        if (cnt < nodes.length) {
                            Object[] ntmp = new Object[cnt];
                            int[] itmp = new int[cnt];
                            System.arraycopy(nodes, 0, ntmp, 0, cnt);
                            System.arraycopy(indices, 0, itmp, 0, cnt);
                            nodes = ntmp;
                            indices = itmp;
                        }
                        path = this.buildTreePath(parents[i]);
                    }
                } else {
                    if (!$assertionsDisabled && set.size() != 1) {
                        throw new AssertionError(set);
                    }
                    indices = null;
                    nodes = null;
                    path = this.buildTreePath((IComponentTreeNode)set.iterator().next());
                }
                if (skip) continue;
                for (int j = 0; j < this.listeners.size(); ++j) {
                    ((TreeModelListener)this.listeners.get(j)).treeNodesChanged(new TreeModelEvent((Object)this, path.toArray(), indices, nodes));
                }
            }
            this.changed = null;
        }
    }

    public void fireNodeRemoved(IComponentTreeNode parent, IComponentTreeNode child, int index) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        List path = this.buildTreePath(parent);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesRemoved(new TreeModelEvent((Object)this, path.toArray(), new int[]{index}, new Object[]{child}));
        }
    }

    public void fireNodeAdded(IComponentTreeNode parent, IComponentTreeNode child, int index) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        List path = this.buildTreePath(parent);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesInserted(new TreeModelEvent((Object)this, path.toArray(), new int[]{index}, new Object[]{child}));
        }
    }

    public List buildTreePath(IComponentTreeNode node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        LinkedList<IComponentTreeNode> path = new LinkedList<IComponentTreeNode>();
        for (IComponentTreeNode pnode = node; pnode != null; pnode = pnode.getParent()) {
            path.add(0, pnode);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNode(IComponentTreeNode node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Map map = this.nodes;
        synchronized (map) {
            if (this.nodes.containsKey(node.getId())) {
                throw new RuntimeException("Node id already contained: " + node + ", " + node.getId());
            }
            this.nodes.put(node.getId(), node);
        }
    }

    public void addNode(IComponentTreeNode node) {
        int i;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.added.put(node.getId(), node);
        INodeListener[] lis = this.nodelisteners.toArray(new INodeListener[this.nodelisteners.size()]);
        for (i = 0; i < lis.length; ++i) {
            lis[i].nodeAdded(node);
        }
        for (i = 0; i < node.getCachedChildren().size(); ++i) {
            this.addNode((IComponentTreeNode)node.getCachedChildren().get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentTreeNode getNode(Object id) {
        IComponentTreeNode ret;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Map map = this.nodes;
        synchronized (map) {
            ret = (IComponentTreeNode)this.nodes.get(id);
        }
        return ret;
    }

    public IComponentTreeNode getAddedNode(Object id) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return (IComponentTreeNode)this.added.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterNode(IComponentTreeNode node) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        node.dispose();
        boolean notify = false;
        Map map = this.nodes;
        synchronized (map) {
            if (this.zombies.contains(node.getId())) {
                this.zombies.remove(node.getId());
                this.nodes.remove(node.getId());
            } else {
                this.nodes.remove(node.getId());
                this.added.remove(node.getId());
                notify = true;
            }
        }
        if (notify) {
            INodeListener[] lis = this.nodelisteners.toArray(new INodeListener[this.nodelisteners.size()]);
            for (int i = 0; i < lis.length; ++i) {
                lis[i].nodeRemoved(node);
            }
        }
        for (int i = 0; i < node.getCachedChildren().size(); ++i) {
            this.deregisterNode((IComponentTreeNode)node.getCachedChildren().get(i));
        }
    }

    public void addNodeHandler(INodeHandler overlay) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.overlays.add(overlay);
    }

    public INodeHandler[] getNodeHandlers() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.overlays.toArray(new INodeHandler[this.overlays.size()]);
    }

    public void addNodeListener(INodeListener listener) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.nodelisteners.add(listener);
    }

    public void removeNodeListener(INodeListener listener) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.nodelisteners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZombieNode(Object id) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Map map = this.nodes;
        synchronized (map) {
            if (!$assertionsDisabled && this.nodes.containsKey(id)) {
                throw new AssertionError(id);
            }
            this.zombies.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZombieNode(Object id) {
        boolean ret;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Map map = this.nodes;
        synchronized (map) {
            ret = this.zombies.contains(id);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IComponentTreeNode[] anodes;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Map map = this.nodes;
        synchronized (map) {
            anodes = this.nodes.values().toArray(new IComponentTreeNode[this.nodes.values().size()]);
        }
        for (int i = 0; i < anodes.length; ++i) {
            anodes[i].dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentTreeNode getNodeOrAddZombie(Object id) {
        IComponentTreeNode ret;
        Map map = this.nodes;
        synchronized (map) {
            ret = (IComponentTreeNode)this.nodes.get(id);
            if (ret == null) {
                this.zombies.add(id);
            }
        }
        return ret;
    }

    static {
        $assertionsDisabled = !ComponentTreeModel.class.desiredAssertionStatus();
    }
}

